/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.oram.Block;
import com.oblivm.backend.oram.OramParty;
import com.oblivm.backend.oram.PlainBlock;

public abstract class TreeBasedOramParty<T>
extends OramParty<T> {
    public PlainBlock[][] tree;
    protected int capacity;

    public TreeBasedOramParty(CompEnv<T> env, int N, int dataSize, int capacity) {
        super(env, N, dataSize);
        this.capacity = capacity;
        if (env.mode != Mode.COUNT) {
            this.tree = new PlainBlock[this.N][capacity];
            PlainBlock b = this.getDummyBlock(this.p == Party.Alice);
            int i = 0;
            while (i < this.N) {
                int j = 0;
                while (j < capacity) {
                    this.tree[i][j] = b;
                    ++j;
                }
                ++i;
            }
        }
    }

    protected PlainBlock[][] getPath(boolean[] path) {
        PlainBlock[][] result = new PlainBlock[this.logN][];
        if (this.env.mode == Mode.COUNT) {
            int i = 0;
            while (i < this.logN) {
                result[i] = new PlainBlock[this.capacity];
                int j = 0;
                while (j < this.capacity) {
                    result[i][j] = this.getDummyBlock(true);
                    ++j;
                }
                ++i;
            }
            return result;
        }
        int index = 1;
        result[0] = this.tree[index];
        int i = 1;
        while (i < this.logN) {
            index *= 2;
            if (path[this.lengthOfPos - i]) {
                ++index;
            }
            result[i] = this.tree[index];
            ++i;
        }
        return result;
    }

    protected void putPath(PlainBlock[][] blocks, boolean[] path) {
        if (this.env.mode == Mode.COUNT) {
            return;
        }
        int index = 1;
        this.tree[index] = blocks[0];
        int i = 1;
        while (i < this.logN) {
            index *= 2;
            if (path[this.lengthOfPos - i]) {
                ++index;
            }
            this.tree[index] = blocks[i];
            ++i;
        }
    }

    public Block<T>[][] preparePath(PlainBlock[][] clientBlock, PlainBlock[][] serverBlock) {
        Block<T>[][] s = this.inputPathOfServer(serverBlock);
        Block<T>[][] c = this.inputPathOfClient(clientBlock);
        return this.lib.xor(s, c);
    }

    public Block<T>[][] inputPathOfClient(PlainBlock[][] b) {
        int length = 0;
        int i = 0;
        while (i < b.length) {
            length += b[i].length;
            ++i;
        }
        PlainBlock[] tmp = new PlainBlock[length];
        int cnt = 0;
        int i2 = 0;
        while (i2 < b.length) {
            int j = 0;
            while (j < b[i2].length) {
                tmp[cnt++] = b[i2][j];
                ++j;
            }
            ++i2;
        }
        Block<T>[] tmpResult = this.inputBucketOfClient(tmp);
        cnt = 0;
        Block<T>[][] result = this.lib.newBlockMatrix(b.length);
        int i3 = 0;
        while (i3 < b.length) {
            result[i3] = this.lib.newBlockArray(b[i3].length);
            int j = 0;
            while (j < b[i3].length) {
                result[i3][j] = tmpResult[cnt++];
                ++j;
            }
            ++i3;
        }
        return result;
    }

    public Block<T>[][] inputPathOfServer(PlainBlock[][] b) {
        int length = 0;
        int i = 0;
        while (i < b.length) {
            length += b[i].length;
            ++i;
        }
        PlainBlock[] tmp = new PlainBlock[length];
        int cnt = 0;
        int i2 = 0;
        while (i2 < b.length) {
            int j = 0;
            while (j < b[i2].length) {
                tmp[cnt++] = b[i2][j];
                ++j;
            }
            ++i2;
        }
        Block<T>[] tmpResult = this.inputBucketOfServer(tmp);
        cnt = 0;
        Block<T>[][] result = this.lib.newBlockMatrix(b.length);
        int i3 = 0;
        while (i3 < b.length) {
            result[i3] = this.lib.newBlockArray(b[i3].length);
            int j = 0;
            while (j < b[i3].length) {
                result[i3][j] = tmpResult[cnt++];
                ++j;
            }
            ++i3;
        }
        return result;
    }

    public PlainBlock[][] preparePlainPath(Block<T>[][] blocks) {
        Block<T>[][] randomSCPath = this.lib.newBlockMatrix(blocks.length);
        PlainBlock[][] randomPath = new PlainBlock[blocks.length][];
        int i = 0;
        while (i < randomPath.length) {
            randomPath[i] = this.randomBucket(blocks[i].length);
            ++i;
        }
        this.env.flush();
        randomSCPath = this.inputPathOfServer(randomPath);
        PlainBlock[][] result = this.outputBuckets(this.lib.xor(blocks, randomSCPath));
        if (this.p == Party.Alice) {
            return result;
        }
        return randomPath;
    }

    public PlainBlock[][] randomPath(PlainBlock[][] path) {
        PlainBlock[][] result = new PlainBlock[path.length][];
        int i = 0;
        while (i < path.length) {
            result[i] = this.randomBucket(path[i].length);
            ++i;
        }
        return result;
    }
}

