/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.argparse4j.annotation.Arg;
import net.sourceforge.argparse4j.helper.ASCIITextWidthCounter;
import net.sourceforge.argparse4j.helper.PrefixPattern;
import net.sourceforge.argparse4j.helper.ReflectHelper;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.helper.TextWidthCounter;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.ArgumentGroupImpl;
import net.sourceforge.argparse4j.internal.ArgumentImpl;
import net.sourceforge.argparse4j.internal.SubparsersImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentParserImpl
implements ArgumentParser {
    private Map<String, ArgumentImpl> optargIndex_ = new HashMap<String, ArgumentImpl>();
    private List<ArgumentImpl> optargs_ = new ArrayList<ArgumentImpl>();
    private List<ArgumentImpl> posargs_ = new ArrayList<ArgumentImpl>();
    private List<ArgumentGroupImpl> arggroups_ = new ArrayList<ArgumentGroupImpl>();
    private Map<String, Object> defaults_ = new HashMap<String, Object>();
    private SubparsersImpl subparsers_ = new SubparsersImpl(this);
    private ArgumentParserImpl mainParser_;
    private String command_;
    private String prog_;
    private String description_ = "";
    private String epilog_ = "";
    private String version_ = "";
    private PrefixPattern prefixPattern_;
    private boolean defaultHelp_ = false;
    private boolean negNumFlag_ = false;
    private TextWidthCounter textWidthCounter_;
    private static final Pattern NEG_NUM_PATTERN = Pattern.compile("-\\d+");
    private static final Pattern SHORT_OPTS_PATTERN = Pattern.compile("-[^-].*");
    public static final int FORMAT_WIDTH = 75;
    public static final String PREFIX_CHARS = "-";

    public ArgumentParserImpl(String prog) {
        this(prog, true, PREFIX_CHARS, new ASCIITextWidthCounter(), null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp) {
        this(prog, addHelp, PREFIX_CHARS, new ASCIITextWidthCounter(), null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp, String prefixChars) {
        this(prog, addHelp, prefixChars, new ASCIITextWidthCounter(), null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp, String prefixChars, TextWidthCounter textWidthCounter) {
        this(prog, addHelp, prefixChars, textWidthCounter, null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp, String prefixChars, TextWidthCounter textWidthCounter, String command, ArgumentParserImpl mainParser) {
        this.prog_ = TextHelper.nonNull(prog);
        this.command_ = command;
        this.mainParser_ = mainParser;
        this.textWidthCounter_ = textWidthCounter;
        if (prefixChars == null || prefixChars.isEmpty()) {
            throw new IllegalArgumentException("prefixChars cannot be a null or empty");
        }
        this.prefixPattern_ = new PrefixPattern(prefixChars);
        if (addHelp) {
            String prefix = prefixChars.substring(0, 1);
            this.addArgument(prefix + "h", prefix + prefix + "help").action(Arguments.help()).help("show this help message and exit").setDefault(Arguments.SUPPRESS);
        }
    }

    @Override
    public ArgumentImpl addArgument(String ... nameOrFlags) {
        return this.addArgument((ArgumentGroup)null, nameOrFlags);
    }

    public ArgumentImpl addArgument(ArgumentGroup group, String ... nameOrFlags) {
        ArgumentImpl arg = new ArgumentImpl(this.prefixPattern_, group, nameOrFlags);
        if (arg.isOptionalArgument()) {
            for (String flag : arg.getFlags()) {
                ArgumentImpl another = this.optargIndex_.get(flag);
                if (another == null) continue;
                throw new IllegalArgumentException(String.format("argument %s: conflicting option string(s): %s", flag, another.textualName()));
            }
            for (String flag : arg.getFlags()) {
                if (NEG_NUM_PATTERN.matcher(flag).matches()) {
                    this.negNumFlag_ = true;
                }
                this.optargIndex_.put(flag, arg);
            }
            this.optargs_.add(arg);
        } else {
            for (ArgumentImpl another : this.posargs_) {
                if (!arg.getName().equals(another.getName())) continue;
                throw new IllegalArgumentException(String.format("argument %s: conflicting option string(s): %s", arg.getName(), another.textualName()));
            }
            this.posargs_.add(arg);
        }
        return arg;
    }

    @Override
    public Subparsers addSubparsers() {
        return this.subparsers_;
    }

    @Override
    public ArgumentGroup addArgumentGroup(String title) {
        ArgumentGroupImpl group = new ArgumentGroupImpl(this, title);
        this.arggroups_.add(group);
        return group;
    }

    @Override
    public ArgumentParserImpl description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    @Override
    public ArgumentParserImpl epilog(String epilog) {
        this.epilog_ = TextHelper.nonNull(epilog);
        return this;
    }

    @Override
    public ArgumentParserImpl version(String version) {
        this.version_ = TextHelper.nonNull(version);
        return this;
    }

    @Override
    public ArgumentParserImpl defaultHelp(boolean defaultHelp) {
        this.defaultHelp_ = defaultHelp;
        return this;
    }

    public boolean isDefaultHelp() {
        return this.defaultHelp_;
    }

    private void printArgumentHelp(PrintWriter writer, List<ArgumentImpl> args) {
        for (ArgumentImpl arg : args) {
            if (arg.getArgumentGroup() != null) continue;
            arg.printHelp(writer, this.defaultHelp_, this.textWidthCounter_, 75);
        }
    }

    @Override
    public void printHelp() {
        PrintWriter writer = new PrintWriter(System.out);
        this.printHelp(writer);
        writer.close();
    }

    @Override
    public void printHelp(PrintWriter writer) {
        boolean subparsersUntitled;
        this.printUsage(writer);
        if (!this.description_.isEmpty()) {
            writer.format("\n%s\n", TextHelper.wrap(this.textWidthCounter_, this.description_, 75, 0, "", ""));
        }
        boolean bl = subparsersUntitled = this.subparsers_.getTitle().isEmpty() && this.subparsers_.getDescription().isEmpty();
        if (this.checkDefaultGroup(this.posargs_) || this.subparsers_.hasSubCommand() && subparsersUntitled) {
            writer.print("\npositional arguments:\n");
            this.printArgumentHelp(writer, this.posargs_);
            if (this.subparsers_.hasSubCommand() && subparsersUntitled) {
                this.subparsers_.printSubparserHelp(writer);
            }
        }
        if (this.checkDefaultGroup(this.optargs_)) {
            writer.print("\noptional arguments:\n");
            this.printArgumentHelp(writer, this.optargs_);
        }
        if (this.subparsers_.hasSubCommand() && !subparsersUntitled) {
            writer.format("\n%s:\n", this.subparsers_.getTitle().isEmpty() ? "subcommands" : this.subparsers_.getTitle());
            if (!this.subparsers_.getDescription().isEmpty()) {
                writer.format("  %s\n\n", TextHelper.wrap(this.textWidthCounter_, this.subparsers_.getDescription(), 75, 2, "", "  "));
            }
            this.subparsers_.printSubparserHelp(writer);
        }
        for (ArgumentGroupImpl group : this.arggroups_) {
            writer.print("\n");
            group.printHelp(writer);
        }
        if (!this.epilog_.isEmpty()) {
            writer.format("\n%s\n", TextHelper.wrap(this.textWidthCounter_, this.epilog_, 75, 0, "", ""));
        }
        writer.flush();
    }

    private boolean checkDefaultGroup(List<ArgumentImpl> args) {
        if (args.isEmpty()) {
            return false;
        }
        for (ArgumentImpl arg : args) {
            if (arg.getArgumentGroup() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String formatHelp() {
        StringWriter writer = new StringWriter();
        this.printHelp(new PrintWriter(writer));
        return writer.toString();
    }

    private void printArgumentUsage(PrintWriter writer, List<String> opts, int offset, String firstIndent, String subsequentIndent) {
        int currentWidth = offset + firstIndent.length();
        writer.print(firstIndent);
        boolean first = true;
        for (String syntax : opts) {
            if (!first && currentWidth + syntax.length() + 1 > 75) {
                writer.print("\n");
                writer.print(subsequentIndent);
                writer.print(" ");
                writer.print(syntax);
                currentWidth = subsequentIndent.length() + 1 + syntax.length();
                continue;
            }
            writer.print(" ");
            writer.print(syntax);
            currentWidth += 1 + syntax.length();
            first = false;
        }
        writer.print("\n");
    }

    @Override
    public void printUsage() {
        this.printUsage(new PrintWriter(System.out));
    }

    @Override
    public void printUsage(PrintWriter writer) {
        String firstIndent;
        String subsequentIndent;
        int offset;
        String usageprog = String.format("usage: %s", this.prog_);
        writer.print(usageprog);
        String indent = "                              ";
        int usageprogWidth = this.textWidthCounter_.width(usageprog);
        if (usageprogWidth > indent.length()) {
            writer.print("\n");
            offset = 6;
            firstIndent = subsequentIndent = indent.substring(0, offset);
        } else {
            offset = usageprogWidth;
            firstIndent = "";
            subsequentIndent = indent.substring(0, offset);
        }
        ArrayList<String> opts = new ArrayList<String>();
        if (this.mainParser_ != null) {
            for (ArgumentImpl arg : this.mainParser_.posargs_) {
                opts.add(arg.formatShortSyntax());
            }
        }
        if (this.command_ != null) {
            opts.add(this.command_);
        }
        for (ArgumentImpl arg : this.optargs_) {
            opts.add(arg.formatShortSyntax());
        }
        for (ArgumentImpl arg : this.posargs_) {
            opts.add(arg.formatShortSyntax());
        }
        if (this.subparsers_.hasSubCommand()) {
            opts.add(this.subparsers_.formatShortSyntax());
            opts.add("...");
        }
        this.printArgumentUsage(writer, opts, offset, firstIndent, subsequentIndent);
    }

    @Override
    public String formatUsage() {
        StringWriter writer = new StringWriter();
        this.printUsage(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public ArgumentParserImpl setDefault(String dest, Object value) {
        this.defaults_.put(dest, value);
        return this;
    }

    @Override
    public ArgumentParser setDefaults(Map<String, Object> attrs) {
        this.defaults_.putAll(attrs);
        return this;
    }

    @Override
    public Object getDefault(String dest) {
        for (ArgumentImpl arg : this.optargs_) {
            if (!dest.equals(arg.getDest()) || arg.getDefault() == null) continue;
            return arg.getDefault();
        }
        for (ArgumentImpl arg : this.posargs_) {
            if (!dest.equals(arg.getDest()) || arg.getDefault() == null) continue;
            return arg.getDefault();
        }
        return this.defaults_.get(dest);
    }

    @Override
    public Namespace parseArgs(String[] args) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseArgs(args, attrs);
        return new Namespace(attrs);
    }

    @Override
    public void parseArgs(String[] args, Map<String, Object> attrs) throws ArgumentParserException {
        this.parseArgs(args, 0, attrs);
    }

    @Override
    public void parseArgs(String[] args, Object userData) throws ArgumentParserException {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        this.parseArgs(args, opts, userData);
    }

    @Override
    public void parseArgs(String[] args, Map<String, Object> attrs, Object userData) throws ArgumentParserException {
        Object val;
        Arg ann;
        this.parseArgs(args, 0, attrs);
        for (Field field : userData.getClass().getDeclaredFields()) {
            ann = field.getAnnotation(Arg.class);
            if (ann == null || !attrs.containsKey(ann.dest())) continue;
            val = attrs.get(ann.dest());
            try {
                field.setAccessible(true);
                field.set(userData, ReflectHelper.list2Array(field.getType(), val));
            }
            catch (RuntimeException e) {
                if (ann.ignoreError()) continue;
                throw e;
            }
            catch (Exception e) {
                if (ann.ignoreError()) continue;
                throw new IllegalArgumentException(String.format("Could not set %s to field %s", val, field.getName()), e);
            }
        }
        for (AccessibleObject accessibleObject : userData.getClass().getDeclaredMethods()) {
            ann = ((Method)accessibleObject).getAnnotation(Arg.class);
            if (ann == null || !attrs.containsKey(ann.dest())) continue;
            val = attrs.get(ann.dest());
            Class<?>[] fargs = ((Method)accessibleObject).getParameterTypes();
            if (fargs.length != 1) {
                throw new IllegalArgumentException(String.format("Method %s must have one formal parameter", ((Method)accessibleObject).getName()));
            }
            try {
                ((Method)accessibleObject).setAccessible(true);
                ((Method)accessibleObject).invoke(userData, ReflectHelper.list2Array(fargs[0], val));
            }
            catch (RuntimeException e) {
                if (ann.ignoreError()) continue;
                throw e;
            }
            catch (Exception e) {
                if (ann.ignoreError()) continue;
                throw new IllegalArgumentException(String.format("Could not call method %s with %s", ((Method)accessibleObject).getName(), val), e);
            }
        }
    }

    public void parseArgs(String[] args, int offset, Map<String, Object> attrs) throws ArgumentParserException {
        ParseState state = new ParseState(this.negNumFlag_);
        this.populateDefaults(attrs);
        HashSet<ArgumentImpl> used = new HashSet<ArgumentImpl>();
        int len = args.length;
        int posargIndex = 0;
        int posargsLen = this.posargs_.size();
        int argIndex = offset;
        while (argIndex < len) {
            String term = args[argIndex];
            if (this.flagFound(term, state) && !"--".equals(term)) {
                String embeddedValue;
                String flag;
                int p = term.indexOf("=");
                if (p == -1) {
                    flag = term;
                    embeddedValue = null;
                } else {
                    flag = term.substring(0, p);
                    embeddedValue = term.substring(p + 1);
                }
                ArgumentImpl arg = this.optargIndex_.get(flag);
                if (arg == null) {
                    boolean shortOptsFound = false;
                    if (SHORT_OPTS_PATTERN.matcher(term).matches() && this.optargIndex_.get(term) == null) {
                        shortOptsFound = true;
                        int termlen = term.length();
                        for (int i = 1; i < termlen; ++i) {
                            String shortFlag = PREFIX_CHARS + term.substring(i, i + 1);
                            arg = this.optargIndex_.get(shortFlag);
                            if (arg == null) {
                                shortOptsFound = false;
                                break;
                            }
                            if (arg.getAction().consumeArgument()) {
                                flag = shortFlag;
                                shortOptsFound = true;
                                embeddedValue = term.substring(i + 1);
                                break;
                            }
                            arg.run(this, attrs, shortFlag, null);
                            used.add(arg);
                        }
                    }
                    if (!shortOptsFound) {
                        throw new ArgumentParserException(String.format("unrecognized arguments: %s", term));
                    }
                }
                assert (arg.getAction() != null);
                argIndex = this.processArg(attrs, state, arg, args, argIndex + 1, flag, embeddedValue);
                used.add(arg);
                continue;
            }
            if ("--".equals(term) && !state.consumedSeparator) {
                state.consumedSeparator = true;
                state.negNumFlag = false;
                ++argIndex;
                continue;
            }
            if (posargIndex < posargsLen) {
                ArgumentImpl arg = this.posargs_.get(posargIndex++);
                argIndex = this.processArg(attrs, state, arg, args, argIndex, null, null);
                continue;
            }
            if (!state.consumedSeparator && this.subparsers_.hasSubCommand()) {
                this.checkRequiredArgument(used, posargIndex);
                this.subparsers_.parseArg(args, argIndex, attrs);
                return;
            }
            throw new ArgumentParserException(String.format("unrecognized arguments: %s", TextHelper.concat(args, argIndex, " ")));
        }
        if (this.subparsers_.hasSubCommand()) {
            throw new ArgumentParserException("too few arguments");
        }
        while (posargIndex < posargsLen) {
            ArgumentImpl arg = this.posargs_.get(posargIndex++);
            int temp = this.processArg(attrs, state, arg, args, len, null, null);
            assert (temp == len);
        }
        this.checkRequiredArgument(used, posargIndex);
    }

    private int processArg(Map<String, Object> res, ParseState state, ArgumentImpl arg, String[] args, int argIndex, String flag, String embeddedValue) throws ArgumentParserException {
        if (!arg.getAction().consumeArgument()) {
            if (embeddedValue == null) {
                arg.run(this, res, flag, null);
                return argIndex;
            }
            throw new ArgumentParserException(String.format("ignore implicit argument '%s'", embeddedValue), arg);
        }
        int len = args.length;
        if (arg.getMinNumArg() == -1 || arg.getMinNumArg() == 0 && arg.getMaxNumArg() == 1) {
            String argval = null;
            if (embeddedValue == null) {
                if (argIndex < len && !this.flagFound(args[argIndex], state)) {
                    argval = args[argIndex];
                    ++argIndex;
                }
            } else {
                argval = embeddedValue;
            }
            if (argval == null) {
                if (arg.getMinNumArg() == -1) {
                    if (arg.isOptionalArgument()) {
                        throw new ArgumentParserException("expected one argument", arg);
                    }
                    throw new ArgumentParserException("too few arguments");
                }
                if (arg.isOptionalArgument()) {
                    arg.run(this, res, flag, arg.getConst());
                }
            } else {
                arg.run(this, res, flag, arg.convert(this, argval));
            }
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            if (embeddedValue == null) {
                String argval;
                for (int i = 0; i < arg.getMaxNumArg() && argIndex < len && !this.flagFound(argval = args[argIndex], state); ++i, ++argIndex) {
                    list.add(arg.convert(this, argval));
                }
            } else {
                list.add(embeddedValue);
            }
            if (list.size() < arg.getMinNumArg()) {
                if (arg.isOptionalArgument()) {
                    throw new ArgumentParserException(String.format("expected %d argument(s)", arg.getMinNumArg()), arg);
                }
                throw new ArgumentParserException("too few arguments");
            }
            arg.run(this, res, flag, list);
        }
        return argIndex;
    }

    private boolean flagFound(String term, ParseState state) {
        if (state.consumedSeparator) {
            return false;
        }
        if ("--".equals(term)) {
            return true;
        }
        return this.prefixPattern_.match(term) && (state.negNumFlag || !NEG_NUM_PATTERN.matcher(term).matches());
    }

    private void checkRequiredArgument(Set<ArgumentImpl> used, int posargIndex) throws ArgumentParserException {
        for (ArgumentImpl arg : this.optargs_) {
            if (!arg.isRequired() || used.contains(arg)) continue;
            throw new ArgumentParserException(String.format("argument %s is required", arg.textualName()));
        }
        if (this.posargs_.size() > posargIndex) {
            throw new ArgumentParserException("too few arguments");
        }
    }

    private void populateDefaults(Map<String, Object> opts) {
        for (ArgumentImpl argumentImpl : this.posargs_) {
            if (argumentImpl.getDefaultControl() == Arguments.SUPPRESS) continue;
            opts.put(argumentImpl.getDest(), argumentImpl.getDefault());
        }
        for (ArgumentImpl argumentImpl : this.optargs_) {
            if (argumentImpl.getDefaultControl() == Arguments.SUPPRESS) continue;
            opts.put(argumentImpl.getDest(), argumentImpl.getDefault());
        }
        for (Map.Entry entry : this.defaults_.entrySet()) {
            opts.put((String)entry.getKey(), entry.getValue());
        }
    }

    public String getProg() {
        return this.prog_;
    }

    @Override
    public void printVersion() {
        this.printVersion(new PrintWriter(System.out));
    }

    @Override
    public void printVersion(PrintWriter writer) {
        writer.format("%s\n", this.version_);
        writer.flush();
    }

    @Override
    public String formatVersion() {
        return this.version_;
    }

    @Override
    public void handleError(ArgumentParserException e) {
        PrintWriter writer = new PrintWriter(System.err);
        this.printUsage(writer);
        writer.format("%s: error: %s\n", this.prog_, e.getMessage());
        writer.close();
    }

    public String getCommand() {
        return this.command_;
    }

    public TextWidthCounter getTextWidthCounter() {
        return this.textWidthCounter_;
    }

    private static class ParseState {
        public boolean consumedSeparator;
        public boolean negNumFlag;

        public ParseState(boolean negNumFlag) {
            this.negNumFlag = negNumFlag;
        }
    }
}

