/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.flexsc;

import com.oblivm.backend.flexsc.BooleanCompEnv;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.util.Utils;

public class PMCompEnv
extends BooleanCompEnv {
    public Statistics statistic;

    public PMCompEnv(Network channel, Party p) {
        super(channel, p, Mode.COUNT);
        this.party = p;
        this.t = true;
        this.f = false;
        this.statistic = new Statistics();
    }

    @Override
    public Boolean inputOfAlice(boolean in) {
        return this.f;
    }

    @Override
    public Boolean inputOfBob(boolean in) {
        ++this.statistic.OTs;
        this.statistic.bandwidth += 10L;
        return this.f;
    }

    @Override
    public boolean outputToAlice(Boolean out) {
        this.statistic.bandwidth += 10L;
        return false;
    }

    @Override
    public boolean outputToBob(Boolean out) {
        this.statistic.bandwidth += 10L;
        return false;
    }

    @Override
    public Boolean and(Boolean a, Boolean b) {
        ++this.statistic.andGate;
        this.statistic.bandwidth += 30L;
        return this.f;
    }

    @Override
    public Boolean xor(Boolean a, Boolean b) {
        ++this.statistic.xorGate;
        return this.f;
    }

    @Override
    public Boolean not(Boolean a) {
        ++this.statistic.notGate;
        return this.f;
    }

    public boolean[] outputToAlice(Boolean[] out) {
        this.statistic.bandwidth += (long)(10 * out.length);
        return Utils.tobooleanArray(out);
    }

    public boolean[] outputToBob(Boolean[] out) {
        this.statistic.bandwidth += (long)(10 * out.length);
        return Utils.tobooleanArray(out);
    }

    public Boolean[] inputOfAlice(boolean[] in) {
        this.statistic.bandwidth += (long)(10 * in.length);
        return Utils.toBooleanArray(in);
    }

    public Boolean[] inputOfBob(boolean[] in) {
        this.statistic.OTs += (long)in.length;
        this.statistic.bandwidth += (long)(20 * (80 + in.length));
        return Utils.toBooleanArray(in);
    }

    public static class Statistics {
        public long andGate = 0L;
        public long xorGate = 0L;
        public long notGate = 0L;
        public long OTs = 0L;
        public long NumEncAlice = 0L;
        public long NumEncBob = 0L;
        public long bandwidth = 0L;

        public void flush() {
            this.bandwidth = 0L;
            this.andGate = 0L;
            this.xorGate = 0L;
            this.notGate = 0L;
            this.OTs = 0L;
            this.NumEncAlice = 0L;
            this.NumEncBob = 0L;
        }

        public void add(Statistics s2) {
            this.andGate += s2.andGate;
            this.xorGate += s2.xorGate;
            this.notGate += s2.notGate;
            this.OTs += s2.OTs;
            this.NumEncAlice += s2.NumEncAlice;
            this.NumEncBob += s2.NumEncBob;
            this.bandwidth += s2.bandwidth;
        }

        public void finalize() {
            this.NumEncAlice = this.andGate * 4L + this.OTs * 2L;
            this.NumEncBob = this.andGate * 1L + this.OTs * 1L;
        }

        public Statistics newInstance() {
            Statistics s = new Statistics();
            s.andGate = this.andGate;
            s.xorGate = this.xorGate;
            s.notGate = this.notGate;
            s.OTs = this.OTs;
            s.NumEncAlice = this.NumEncAlice;
            s.NumEncBob = this.NumEncBob;
            s.bandwidth = this.bandwidth;
            return s;
        }
    }
}

