/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.example;

import com.oblivm.backend.circuits.arithmetic.IntegerLib;
import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.gc.BadLabelException;
import com.oblivm.backend.util.EvaRunnable;
import com.oblivm.backend.util.GenRunnable;

public class HammingDistance {
    public static <T> T[] compute(CompEnv<T> gen, T[] inputA, T[] inputB) {
        return new IntegerLib<T>(gen).hammingDistance(inputA, inputB);
    }

    public static class Evaluator<T>
    extends EvaRunnable<T> {
        T[] inputA;
        T[] inputB;
        T[] scResult;

        @Override
        public void prepareInput(CompEnv<T> gen) {
            boolean[] in = new boolean[10000];
            int i = 0;
            while (i < in.length) {
                in[i] = CompEnv.rnd.nextBoolean();
                ++i;
            }
            this.inputA = gen.inputOfAlice(new boolean[10000]);
            gen.flush();
            this.inputB = gen.inputOfBob(in);
        }

        @Override
        public void secureCompute(CompEnv<T> gen) {
            this.scResult = HammingDistance.compute(gen, this.inputA, this.inputB);
        }

        @Override
        public void prepareOutput(CompEnv<T> gen) throws BadLabelException {
            gen.outputToAlice(this.scResult);
        }
    }

    public static class Generator<T>
    extends GenRunnable<T> {
        T[] inputA;
        T[] inputB;
        T[] scResult;

        @Override
        public void prepareInput(CompEnv<T> gen) {
            boolean[] in = new boolean[10000];
            int i = 0;
            while (i < in.length) {
                in[i] = CompEnv.rnd.nextBoolean();
                ++i;
            }
            this.inputA = gen.inputOfAlice(in);
            gen.flush();
            this.inputB = gen.inputOfBob(new boolean[10000]);
        }

        @Override
        public void secureCompute(CompEnv<T> gen) {
            this.scResult = HammingDistance.compute(gen, this.inputA, this.inputB);
        }

        @Override
        public void prepareOutput(CompEnv<T> gen) throws BadLabelException {
            System.out.println(gen.outputToAlice(this.scResult));
        }
    }
}

