/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.internal.ArgumentImpl;
import net.sourceforge.argparse4j.internal.ArgumentParserImpl;

public final class ArgumentGroupImpl
implements ArgumentGroup {
    private String title_ = "";
    private String description_ = "";
    private ArgumentParserImpl argumentParser_;
    private List<ArgumentImpl> args_ = new ArrayList<ArgumentImpl>();

    public ArgumentGroupImpl(ArgumentParserImpl argumentParser, String title) {
        this.argumentParser_ = argumentParser;
        this.title_ = TextHelper.nonNull(title);
    }

    public ArgumentGroup description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    public ArgumentImpl addArgument(String ... nameOrFlags) {
        ArgumentImpl arg = this.argumentParser_.addArgument(this, nameOrFlags);
        this.args_.add(arg);
        return arg;
    }

    public void printHelp(PrintWriter writer) {
        if (!this.title_.isEmpty()) {
            writer.format("%s:\n", this.title_);
        }
        if (!this.description_.isEmpty()) {
            writer.format("  %s\n\n", TextHelper.wrap(this.argumentParser_.getTextWidthCounter(), this.description_, 75, 2, "", "  "));
        }
        for (ArgumentImpl arg : this.args_) {
            arg.printHelp(writer, this.argumentParser_.isDefaultHelp(), this.argumentParser_.getTextWidthCounter(), 75);
        }
    }
}

