/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.gc;

import com.oblivm.backend.network.Network;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;

public class GCSignal {
    public static final int len = 10;
    public byte[] bytes;
    public boolean v;
    public static final GCSignal ZERO = new GCSignal(new byte[10]);

    public GCSignal(byte[] b) {
        this.bytes = b;
    }

    public GCSignal(boolean b) {
        this.v = b;
    }

    public static GCSignal freshLabel(SecureRandom rnd) {
        byte[] b = new byte[10];
        rnd.nextBytes(b);
        return new GCSignal(b);
    }

    public static GCSignal newInstance(byte[] bs) {
        assert (bs.length <= 10) : "Losing entropy when constructing signals.";
        byte[] b = new byte[10];
        Arrays.fill(b, (byte)(bs[0] < 0 ? 255 : 0));
        int newlen = 10 < bs.length ? 10 : bs.length;
        System.arraycopy(bs, 0, b, 10 - newlen, newlen);
        return new GCSignal(b);
    }

    public GCSignal(GCSignal lb) {
        this.v = lb.v;
        this.bytes = lb.bytes == null ? null : Arrays.copyOf(lb.bytes, 10);
    }

    public boolean isPublic() {
        return this.bytes == null;
    }

    public GCSignal xor(GCSignal lb) {
        byte[] nb = new byte[10];
        int i = 0;
        while (i < 10) {
            nb[i] = (byte)(this.bytes[i] ^ lb.bytes[i]);
            ++i;
        }
        return new GCSignal(nb);
    }

    public static void xor(GCSignal l, GCSignal r, GCSignal ret) {
        int i = 0;
        while (i < 10) {
            ret.bytes[i] = (byte)(l.bytes[i] ^ r.bytes[i]);
            ++i;
        }
    }

    public void setLSB() {
        this.bytes[0] = (byte)(this.bytes[0] | 1);
    }

    public int getLSB() {
        return this.bytes[0] & 1;
    }

    public void send(Network channel) {
        channel.writeByte(this.bytes, 10);
    }

    public void send(OutputStream os) {
        try {
            os.write(this.bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static GCSignal receive(Network channel) {
        byte[] b = channel.readBytes(10);
        return new GCSignal(b);
    }

    public static void receive(Network channel, GCSignal s) {
        if (s.bytes == null) {
            s.bytes = new byte[10];
        }
        channel.readBytes(s.bytes);
    }

    public boolean equals(Object lb) {
        if (this == lb) {
            return true;
        }
        if (lb instanceof GCSignal) {
            return Arrays.equals(this.bytes, ((GCSignal)lb).bytes);
        }
        return false;
    }

    public String toHexStr() {
        StringBuilder str = new StringBuilder();
        byte[] byArray = this.bytes;
        int n = this.bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            str.append(Integer.toHexString(b & 0xFF));
            ++n2;
        }
        return str.toString();
    }
}

