/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.circuits.arithmetic;

import com.oblivm.backend.circuits.CircuitLib;
import com.oblivm.backend.circuits.arithmetic.ArithmeticLib;
import com.oblivm.backend.circuits.arithmetic.FixedPointLib;
import com.oblivm.backend.circuits.arithmetic.FloatLib;
import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.util.Utils;
import java.util.Arrays;

public class IntegerLib<T>
extends CircuitLib<T>
implements ArithmeticLib<T> {
    public int width;
    static final int S = 0;
    static final int COUT = 1;

    public IntegerLib(CompEnv<T> e) {
        super(e);
        this.width = 32;
    }

    public IntegerLib(CompEnv<T> e, int width) {
        super(e);
        this.width = width;
    }

    @Override
    public T[] publicValue(double v) {
        int intv = (int)v;
        return this.toSignals(intv, this.width);
    }

    protected T[] add(T x, T y, T cin) {
        T[] res = this.env.newTArray(2);
        T t1 = this.xor(x, cin);
        T t2 = this.xor(y, cin);
        res[0] = this.xor(x, t2);
        t1 = this.and(t1, t2);
        res[1] = this.xor(cin, t1);
        return res;
    }

    public T[] addFull(T[] x, T[] y, boolean cin) {
        assert (x != null && y != null && x.length == y.length) : "add: bad inputs.";
        T[] res = this.env.newTArray(x.length + 1);
        T[] t = this.add(x[0], y[0], this.env.newT(cin));
        res[0] = t[0];
        int i = 0;
        while (i < x.length - 1) {
            t = this.add(x[i + 1], y[i + 1], t[1]);
            res[i + 1] = t[0];
            ++i;
        }
        res[res.length - 1] = t[1];
        return res;
    }

    public T[] add(T[] x, T[] y, boolean cin) {
        return Arrays.copyOf(this.addFull(x, y, cin), x.length);
    }

    @Override
    public T[] add(T[] x, T[] y) {
        return this.add(x, y, false);
    }

    public T[] sub(T x, T y) throws Exception {
        T[] ax = this.env.newTArray(2);
        ax[1] = this.SIGNAL_ZERO;
        ax[0] = x;
        T[] ay = this.env.newTArray(2);
        ay[1] = this.SIGNAL_ZERO;
        ay[0] = y;
        return this.sub(x, y);
    }

    @Override
    public T[] sub(T[] x, T[] y) {
        assert (x != null && y != null && x.length == y.length) : "sub: bad inputs.";
        return this.add(x, this.not(y), true);
    }

    public T[] incrementByOne(T[] x) {
        T[] one = this.zeros(x.length);
        one[0] = this.SIGNAL_ONE;
        return this.add(x, one);
    }

    public T[] decrementByOne(T[] x) {
        T[] one = this.zeros(x.length);
        one[0] = this.SIGNAL_ONE;
        return this.sub(x, one);
    }

    public T[] conditionalIncreament(T[] x, T flag) {
        T[] one = this.zeros(x.length);
        one[0] = this.mux(this.SIGNAL_ZERO, this.SIGNAL_ONE, flag);
        return this.add(x, one);
    }

    public T[] conditionalDecrement(T[] x, T flag) {
        T[] one = this.zeros(x.length);
        one[0] = this.mux(this.SIGNAL_ZERO, this.SIGNAL_ONE, flag);
        return this.sub(x, one);
    }

    public T geq(T[] x, T[] y) {
        assert (x.length == y.length) : "bad input";
        T[] result = this.sub(x, y);
        return this.not(result[result.length - 1]);
    }

    @Override
    public T leq(T[] x, T[] y) {
        return this.geq(y, x);
    }

    @Override
    public T[] multiply(T[] x, T[] y) {
        return Arrays.copyOf(this.multiplyInternal(x, y), x.length);
    }

    public T[] multiplyFull(T[] x, T[] y) {
        return this.multiplyInternal(x, y);
    }

    private T[] multiplyInternal(T[] x, T[] y) {
        assert (x != null && y != null) : "multiply: bad inputs";
        T[] res = this.zeros(x.length + y.length);
        T[] zero = this.zeros(x.length);
        T[] toAdd = this.mux(zero, x, y[0]);
        System.arraycopy(toAdd, 0, res, 0, toAdd.length);
        int i = 1;
        while (i < y.length) {
            toAdd = Arrays.copyOfRange(res, i, i + x.length);
            toAdd = this.add(toAdd, this.mux(zero, x, y[i]), false);
            System.arraycopy(toAdd, 0, res, i, toAdd.length);
            ++i;
        }
        return res;
    }

    public T[] absolute(T[] x) {
        Object reachedOneSignal = this.SIGNAL_ZERO;
        T[] result = this.zeros(x.length);
        int i = 0;
        while (i < x.length) {
            Object comp = this.eq(this.SIGNAL_ONE, x[i]);
            result[i] = this.xor(x[i], reachedOneSignal);
            reachedOneSignal = this.or(reachedOneSignal, comp);
            ++i;
        }
        return this.mux(x, result, x[x.length - 1]);
    }

    @Override
    public T[] div(T[] x, T[] y) {
        T[] absoluteX = this.absolute(x);
        T[] absoluteY = this.absolute(y);
        T[] PA = this.divInternal(absoluteX, absoluteY);
        return this.addSign(Arrays.copyOf(PA, x.length), this.xor(x[x.length - 1], y[y.length - 1]));
    }

    public T[] divInternal(T[] x, T[] y) {
        T[] PA = this.zeros(x.length + y.length);
        T[] B = y;
        System.arraycopy(x, 0, PA, 0, x.length);
        int i = 0;
        while (i < x.length) {
            PA = this.leftShift(PA);
            T[] tempP = this.sub(Arrays.copyOfRange(PA, x.length, PA.length), B);
            PA[0] = this.not(tempP[tempP.length - 1]);
            System.arraycopy(this.mux(tempP, Arrays.copyOfRange(PA, x.length, PA.length), tempP[tempP.length - 1]), 0, PA, x.length, y.length);
            ++i;
        }
        return PA;
    }

    public T[] mod(T[] x, T[] y) {
        T Xneg = x[x.length - 1];
        T[] absoluteX = this.absolute(x);
        T[] absoluteY = this.absolute(y);
        T[] PA = this.divInternal(absoluteX, absoluteY);
        T[] res = Arrays.copyOfRange(PA, y.length, PA.length);
        return this.mux(res, this.sub(this.toSignals(0L, res.length), res), Xneg);
    }

    public T[] addSign(T[] x, T sign) {
        T[] reachedOneSignal = this.zeros(x.length);
        T[] result = this.env.newTArray(x.length);
        int i = 0;
        while (i < x.length - 1) {
            reachedOneSignal[i + 1] = this.or(reachedOneSignal[i], x[i]);
            result[i] = this.xor(x[i], reachedOneSignal[i]);
            ++i;
        }
        result[x.length - 1] = this.xor(x[x.length - 1], reachedOneSignal[x.length - 1]);
        return this.mux(x, result, sign);
    }

    public T[] commonPrefix(T[] x, T[] y) {
        assert (x != null && y != null) : "multiply: bad inputs";
        T[] result = this.xor(x, y);
        int i = x.length - 2;
        while (i >= 0) {
            result[i] = this.or(result[i], result[i + 1]);
            --i;
        }
        return result;
    }

    public T[] leadingZeros(T[] x) {
        assert (x != null) : "leading zeros: bad inputs";
        T[] result = Arrays.copyOf(x, x.length);
        int i = result.length - 2;
        while (i >= 0) {
            result[i] = this.or(result[i], result[i + 1]);
            --i;
        }
        return this.numberOfOnes(this.not(result));
    }

    public T[] lengthOfCommenPrefix(T[] x, T[] y) {
        assert (x != null) : "lengthOfCommenPrefix : bad inputs";
        return this.leadingZeros(this.xor(x, y));
    }

    public T[] leftShift(T[] x) {
        assert (x != null) : "leftShift: bad inputs";
        return this.leftPublicShift(x, 1);
    }

    public T[] rightShift(T[] x) {
        assert (x != null) : "rightShift: bad inputs";
        return this.rightPublicShift(x, 1);
    }

    public T[] leftPublicShift(T[] x, int s) {
        assert (x != null && s < x.length) : "leftshift: bad inputs";
        T[] res = this.env.newTArray(x.length);
        System.arraycopy(this.zeros(s), 0, res, 0, s);
        System.arraycopy(x, 0, res, s, x.length - s);
        return res;
    }

    public T[] rightPublicShift(T[] x, int s) {
        assert (x != null && s < x.length) : "rightshift: bad inputs";
        T[] res = this.env.newTArray(x.length);
        System.arraycopy(x, s, res, 0, x.length - s);
        System.arraycopy(this.zeros(s), 0, res, x.length - s, s);
        return res;
    }

    public T[] conditionalLeftPublicShift(T[] x, int s, T sign) {
        assert (x != null && s < x.length) : "leftshift: bad inputs";
        T[] res = this.env.newTArray(x.length);
        System.arraycopy(this.mux(Arrays.copyOfRange(x, 0, s), this.zeros(s), sign), 0, res, 0, s);
        System.arraycopy(this.mux(Arrays.copyOfRange(x, s, x.length), Arrays.copyOfRange(x, 0, x.length), sign), 0, res, s, x.length - s);
        return res;
    }

    public T[] conditionalRightPublicShift(T[] x, int s, T sign) {
        assert (x != null && s < x.length) : "rightshift: bad inputs";
        T[] res = this.env.newTArray(x.length);
        System.arraycopy(this.mux(Arrays.copyOfRange(x, 0, x.length - s), Arrays.copyOfRange(x, s, x.length), sign), 0, res, 0, x.length - s);
        System.arraycopy(this.mux(Arrays.copyOfRange(x, x.length - s, x.length), this.zeros(s), sign), 0, res, x.length - s, s);
        return res;
    }

    public T[] leftPrivateShift(T[] x, T[] lengthToShift) {
        T[] res = Arrays.copyOf(x, x.length);
        int i = 0;
        while (1 << i < x.length && i < lengthToShift.length) {
            res = this.conditionalLeftPublicShift(res, 1 << i, lengthToShift[i]);
            ++i;
        }
        Object clear = this.SIGNAL_ZERO;
        int i2 = 0;
        while (i2 < lengthToShift.length) {
            if (1 << i2 >= x.length) {
                clear = this.or(clear, lengthToShift[i2]);
            }
            ++i2;
        }
        return this.mux(res, this.zeros(x.length), clear);
    }

    public T[] rightPrivateShift(T[] x, T[] lengthToShift) {
        T[] res = Arrays.copyOf(x, x.length);
        int i = 0;
        while (1 << i < x.length && i < lengthToShift.length) {
            res = this.conditionalRightPublicShift(res, 1 << i, lengthToShift[i]);
            ++i;
        }
        Object clear = this.SIGNAL_ZERO;
        int i2 = 0;
        while (i2 < lengthToShift.length) {
            if (1 << i2 >= x.length) {
                clear = this.or(clear, lengthToShift[i2]);
            }
            ++i2;
        }
        return this.mux(res, this.zeros(x.length), clear);
    }

    T compare(T x, T y, T cin) {
        T t1 = this.xor(x, cin);
        T t2 = this.xor(y, cin);
        t1 = this.and(t1, t2);
        return this.xor(x, t1);
    }

    public T compare(T[] x, T[] y) {
        assert (x != null && y != null && x.length == y.length) : "compare: bad inputs.";
        Object t = this.env.newT(false);
        int i = 0;
        while (i < x.length) {
            t = this.compare(x[i], y[i], t);
            ++i;
        }
        return t;
    }

    public T eq(T x, T y) {
        assert (x != null && y != null) : "CircuitLib.eq: bad inputs";
        return this.not(this.xor(x, y));
    }

    @Override
    public T eq(T[] x, T[] y) {
        assert (x != null && y != null && x.length == y.length) : "CircuitLib.eq[]: bad inputs.";
        Object res = this.env.newT(true);
        int i = 0;
        while (i < x.length) {
            T t = this.eq(x[i], y[i]);
            res = this.env.and(res, t);
            ++i;
        }
        return res;
    }

    public T[] twosComplement(T[] x) {
        Object reachOne = this.SIGNAL_ZERO;
        T[] result = this.env.newTArray(x.length);
        int i = 0;
        while (i < x.length) {
            result[i] = this.xor(x[i], reachOne);
            reachOne = this.or(reachOne, x[i]);
            ++i;
        }
        return result;
    }

    public T[] hammingDistance(T[] x, T[] y) {
        T[] a = this.xor(x, y);
        return this.numberOfOnes(a);
    }

    public T[] numberOfOnes(T[] t) {
        if (t.length == 0) {
            T[] res = this.env.newTArray(1);
            res[0] = this.SIGNAL_ZERO;
            return res;
        }
        if (t.length == 1) {
            return t;
        }
        int length = 1;
        int w = 1;
        while (length <= t.length) {
            length <<= 1;
            ++w;
        }
        T[] res1 = this.numberOfOnesN(Arrays.copyOfRange(t, 0, length >>= 1));
        T[] res2 = this.numberOfOnes(Arrays.copyOfRange(t, length, t.length));
        return this.add(this.padSignal(res1, w), this.padSignal(res2, w));
    }

    public T[] numberOfOnesN(T[] res) {
        if (res.length == 1) {
            return res;
        }
        T[] left = this.numberOfOnesN(Arrays.copyOfRange(res, 0, res.length / 2));
        T[] right = this.numberOfOnesN(Arrays.copyOfRange(res, res.length / 2, res.length));
        return this.unSignedAdd(left, right);
    }

    public T[] unSignedAdd(T[] x, T[] y) {
        assert (x != null && y != null && x.length == y.length) : "add: bad inputs.";
        T[] res = this.env.newTArray(x.length + 1);
        T[] t = this.add(x[0], y[0], this.env.newT(false));
        res[0] = t[0];
        int i = 0;
        while (i < x.length - 1) {
            t = this.add(x[i + 1], y[i + 1], t[1]);
            res[i + 1] = t[0];
            ++i;
        }
        res[res.length - 1] = t[1];
        return res;
    }

    public T[] unSignedMultiply(T[] x, T[] y) {
        assert (x != null && y != null) : "multiply: bad inputs";
        T[] res = this.zeros(x.length + y.length);
        T[] zero = this.zeros(x.length);
        T[] toAdd = this.mux(zero, x, y[0]);
        System.arraycopy(toAdd, 0, res, 0, toAdd.length);
        int i = 1;
        while (i < y.length) {
            toAdd = Arrays.copyOfRange(res, i, i + x.length);
            toAdd = this.unSignedAdd(toAdd, this.mux(zero, x, y[i]));
            System.arraycopy(toAdd, 0, res, i, toAdd.length);
            ++i;
        }
        return res;
    }

    public T[] karatsubaMultiply(T[] x, T[] y) {
        if (x.length <= 18) {
            return this.unSignedMultiply(x, y);
        }
        int length = x.length + y.length;
        T[] xlo = Arrays.copyOfRange(x, 0, x.length / 2);
        T[] xhi = Arrays.copyOfRange(x, x.length / 2, x.length);
        T[] ylo = Arrays.copyOfRange(y, 0, y.length / 2);
        T[] yhi = Arrays.copyOfRange(y, y.length / 2, y.length);
        int nextlength = Math.max(x.length / 2, x.length - x.length / 2);
        xlo = this.padSignal(xlo, nextlength);
        xhi = this.padSignal(xhi, nextlength);
        ylo = this.padSignal(ylo, nextlength);
        yhi = this.padSignal(yhi, nextlength);
        T[] z0 = this.karatsubaMultiply(xlo, ylo);
        T[] z2 = this.karatsubaMultiply(xhi, yhi);
        T[] z1 = this.sub(this.padSignal(this.karatsubaMultiply(this.unSignedAdd(xlo, xhi), this.unSignedAdd(ylo, yhi)), 2 * nextlength + 2), this.padSignal(this.unSignedAdd(this.padSignal(z2, 2 * nextlength), this.padSignal(z0, 2 * nextlength)), 2 * nextlength + 2));
        z1 = this.padSignal(z1, length);
        z1 = this.leftPublicShift(z1, x.length / 2);
        T[] z0Pad = this.padSignal(z0, length);
        T[] z2Pad = this.padSignal(z2, length);
        z2Pad = this.leftPublicShift(z2Pad, 2 * (x.length / 2));
        return this.add(this.add(z0Pad, z1), z2Pad);
    }

    public T[] min(T[] x, T[] y) {
        T leq = this.leq(x, y);
        return this.mux(y, x, leq);
    }

    @Override
    public T[] sqrt(T[] a) {
        int newLength = a.length;
        if (newLength % 2 == 1) {
            ++newLength;
        }
        T[] x = this.padSignal(a, newLength);
        T[] rem = this.zeros(x.length);
        T[] root = this.zeros(x.length);
        int i = 0;
        while (i < x.length / 2) {
            root = this.leftShift(root);
            rem = this.add(this.leftPublicShift(rem, 2), this.rightPublicShift(x, x.length - 2));
            x = this.leftPublicShift(x, 2);
            T[] oldRoot = root;
            root = this.copy(root);
            root[0] = this.SIGNAL_ONE;
            T[] remMinusRoot = this.sub(rem, root);
            Object isRootSmaller = this.not(remMinusRoot[remMinusRoot.length - 1]);
            rem = this.mux(rem, remMinusRoot, isRootSmaller);
            root = this.mux(oldRoot, this.incrementByOne(root), isRootSmaller);
            ++i;
        }
        return this.padSignal(this.rightShift(root), a.length);
    }

    @Override
    public T[] inputOfAlice(double d) {
        return this.env.inputOfAlice(Utils.fromLong((long)d, this.width));
    }

    @Override
    public T[] inputOfBob(double d) {
        return this.env.inputOfBob(Utils.fromLong((long)d, this.width));
    }

    @Override
    public CompEnv<T> getEnv() {
        return this.env;
    }

    @Override
    public T[] toSecureInt(T[] a, IntegerLib<T> lib) {
        return a;
    }

    @Override
    public T[] toSecureFloat(T[] a, FloatLib<T> lib) {
        T[] v = this.padSignal(a, lib.VLength);
        T[] p = this.leadingZeros(v);
        v = this.leftPrivateShift(v, p);
        p = this.padSignal(p, lib.PLength);
        p = this.sub(this.zeros(p.length), p);
        return lib.pack(new FloatLib.Representation<Object>(this.SIGNAL_ZERO, v, p));
    }

    @Override
    public T[] toSecureFixPoint(T[] a, FixedPointLib<T> lib) {
        return this.leftPublicShift(this.padSignal(a, lib.width), lib.offset);
    }

    @Override
    public double outputToAlice(T[] a) {
        return Utils.toInt(this.env.outputToAlice(a));
    }

    @Override
    public int numBits() {
        return this.width;
    }
}

