/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.example;

import com.oblivm.backend.circuits.BitonicSortLib;
import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.util.EvaRunnable;
import com.oblivm.backend.util.GenRunnable;
import com.oblivm.backend.util.Utils;
import java.util.Arrays;

public class Sort {
    public static <T> void compute(CompEnv<T> gen, T[][] inputB) {
        BitonicSortLib<Object> lib = new BitonicSortLib<Object>(gen);
        lib.sort(inputB, lib.SIGNAL_ONE);
    }

    public static class Evaluator<T>
    extends EvaRunnable<T> {
        T[][] inputB;
        T[] scResult;

        @Override
        public void prepareInput(CompEnv<T> gen) {
            this.inputB = gen.newTArray(4000, 0);
            boolean[] temp = new boolean[64000];
            int i = 0;
            while (i < 4000) {
                System.arraycopy(Utils.fromInt(CompEnv.rnd.nextInt(), 16), 0, temp, 16 * i, 16);
                ++i;
            }
            T[] scTemp = gen.inputOfBob(temp);
            int i2 = 0;
            while (i2 < this.inputB.length) {
                this.inputB[i2] = Arrays.copyOfRange(scTemp, i2 * 16, i2 * 16 + 16);
                ++i2;
            }
        }

        @Override
        public void secureCompute(CompEnv<T> gen) {
            Sort.compute(gen, this.inputB);
        }

        @Override
        public void prepareOutput(CompEnv<T> gen) {
        }
    }

    public static class Generator<T>
    extends GenRunnable<T> {
        T[][] inputB;

        @Override
        public void prepareInput(CompEnv<T> gen) {
            this.inputB = gen.newTArray(4000, 0);
            T[] scTemp = gen.inputOfBob(new boolean[64000]);
            int i = 0;
            while (i < this.inputB.length) {
                this.inputB[i] = Arrays.copyOfRange(scTemp, i * 16, i * 16 + 16);
                ++i;
            }
        }

        @Override
        public void secureCompute(CompEnv<T> gen) {
            Sort.compute(gen, this.inputB);
        }

        @Override
        public void prepareOutput(CompEnv<T> gen) {
        }
    }
}

