/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.rand;

class ISAACAlgorithm {
    private static final int SIZEL = 8;
    private static final int SIZE = 256;
    private static final int MASK = 1020;
    private int count;
    private int[] rsl;
    private int[] mem = new int[256];
    private int a;
    private int b;
    private int c;

    ISAACAlgorithm() {
        this.rsl = new int[256];
        this.init(false);
    }

    ISAACAlgorithm(int[] seed) {
        this.rsl = new int[256];
        System.arraycopy(seed, 0, this.rsl, 0, seed.length <= this.rsl.length ? seed.length : this.rsl.length);
        this.init(true);
    }

    private final void isaac() {
        this.b += ++this.c;
        int i = 0;
        while (i < 256) {
            int y;
            int x = this.mem[i];
            switch (i & 3) {
                case 0: {
                    this.a ^= this.a << 13;
                    break;
                }
                case 1: {
                    this.a ^= this.a >>> 6;
                    break;
                }
                case 2: {
                    this.a ^= this.a << 2;
                    break;
                }
                case 3: {
                    this.a ^= this.a >>> 16;
                }
            }
            this.a += this.mem[i + 128 & 0xFF];
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + this.a + this.b;
            this.rsl[i] = this.b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
            ++i;
        }
    }

    private final void init(boolean flag) {
        int h = -1640531527;
        int g = -1640531527;
        int f = -1640531527;
        int e = -1640531527;
        int d = -1640531527;
        int c = -1640531527;
        int b = -1640531527;
        int a = -1640531527;
        int i = 0;
        while (i < 4) {
            d += (a ^= b << 11);
            b += c;
            e += (b ^= c >>> 2);
            c += d;
            f += (c ^= d << 8);
            d += e;
            g += (d ^= e >>> 16);
            e += f;
            h += (e ^= f << 10);
            f += g;
            a += (f ^= g >>> 4);
            g += h;
            b += (g ^= h << 8);
            h += a;
            c += (h ^= a >>> 9);
            a += b;
            ++i;
        }
        i = 0;
        while (i < 256) {
            if (flag) {
                a += this.rsl[i];
                b += this.rsl[i + 1];
                c += this.rsl[i + 2];
                d += this.rsl[i + 3];
                e += this.rsl[i + 4];
                f += this.rsl[i + 5];
                g += this.rsl[i + 6];
                h += this.rsl[i + 7];
            }
            d += (a ^= b << 11);
            b += c;
            e += (b ^= c >>> 2);
            c += d;
            f += (c ^= d << 8);
            d += e;
            g += (d ^= e >>> 16);
            e += f;
            h += (e ^= f << 10);
            f += g;
            a += (f ^= g >>> 4);
            g += h;
            b += (g ^= h << 8);
            h += a;
            c += (h ^= a >>> 9);
            this.mem[i] = a += b;
            this.mem[i + 1] = b;
            this.mem[i + 2] = c;
            this.mem[i + 3] = d;
            this.mem[i + 4] = e;
            this.mem[i + 5] = f;
            this.mem[i + 6] = g;
            this.mem[i + 7] = h;
            i += 8;
        }
        if (flag) {
            i = 0;
            while (i < 256) {
                a += this.mem[i];
                b += this.mem[i + 1];
                c += this.mem[i + 2];
                d += this.mem[i + 3];
                e += this.mem[i + 4];
                f += this.mem[i + 5];
                g += this.mem[i + 6];
                h += this.mem[i + 7];
                d += (a ^= b << 11);
                b += c;
                e += (b ^= c >>> 2);
                c += d;
                f += (c ^= d << 8);
                d += e;
                g += (d ^= e >>> 16);
                e += f;
                h += (e ^= f << 10);
                f += g;
                a += (f ^= g >>> 4);
                g += h;
                b += (g ^= h << 8);
                h += a;
                c += (h ^= a >>> 9);
                this.mem[i] = a += b;
                this.mem[i + 1] = b;
                this.mem[i + 2] = c;
                this.mem[i + 3] = d;
                this.mem[i + 4] = e;
                this.mem[i + 5] = f;
                this.mem[i + 6] = g;
                this.mem[i + 7] = h;
                i += 8;
            }
        }
        this.isaac();
        this.count = 256;
    }

    final int nextInt() {
        if (this.count-- == 0) {
            this.isaac();
            this.count = 255;
        }
        return this.rsl[this.count];
    }

    final void supplementSeed(int[] seed) {
        int i = 0;
        while (i < seed.length) {
            int n = i % this.mem.length;
            this.mem[n] = this.mem[n] ^ seed[i];
            ++i;
        }
    }
}

