/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.ot;

import java.math.BigInteger;
import java.security.SecureRandom;

class BitMatrix {
    private int nRows;
    private int nCols;
    BigInteger[] data;

    public BitMatrix(int rows, int cols) {
        this.nRows = rows;
        this.nCols = cols;
        this.data = new BigInteger[this.nCols];
    }

    public void initialize(SecureRandom rnd) {
        int i = 0;
        while (i < this.nCols) {
            this.data[i] = new BigInteger(this.nRows, rnd);
            ++i;
        }
    }

    public BitMatrix transpose() {
        return BitMatrix.NaiveTranspose(this);
    }

    public static BitMatrix NaiveTranspose(BitMatrix a) {
        BitMatrix b = new BitMatrix(a.nCols, a.nRows);
        int i = 0;
        while (i < a.nRows) {
            b.data[i] = BigInteger.ZERO;
            ++i;
        }
        int j = 0;
        while (j < a.nCols) {
            int i2 = 0;
            while (i2 < a.nRows) {
                if (a.data[j].testBit(i2)) {
                    b.data[i2] = b.data[i2].setBit(j);
                }
                ++i2;
            }
            ++j;
        }
        return b;
    }

    public static BitMatrix COtranspose(BitMatrix a) {
        BitMatrix b = new BitMatrix(a.nCols, a.nRows);
        int i = 0;
        while (i < a.nRows) {
            b.data[i] = BigInteger.ZERO;
            ++i;
        }
        BitMatrix.COtranspose(a, b, 0, 0, a.nRows, a.nCols);
        return b;
    }

    public static void COtranspose(BitMatrix a, BitMatrix b, int startx, int starty, int endx, int endy) {
        if (endy - starty == 1 && endx - startx == 1) {
            if (a.data[starty].testBit(startx)) {
                b.data[startx] = b.data[startx].setBit(starty);
            }
            return;
        }
        if (endy - starty < endx - startx) {
            int midx = (startx + endx) / 2;
            BitMatrix.COtranspose(a, b, startx, starty, midx, endy);
            BitMatrix.COtranspose(a, b, midx, starty, endx, endy);
        } else {
            int midy = (starty + endy) / 2;
            BitMatrix.COtranspose(a, b, startx, starty, endx, midy);
            BitMatrix.COtranspose(a, b, startx, midy, endx, endy);
        }
    }
}

