/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.example;

import com.oblivm.backend.circuits.arithmetic.IntegerLib;
import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.gc.BadLabelException;
import com.oblivm.backend.util.EvaRunnable;
import com.oblivm.backend.util.GenRunnable;
import com.oblivm.backend.util.Utils;

public class Millionaire {
    public static <T> T compute(CompEnv<T> gen, T[] inputA, T[] inputB) {
        return new IntegerLib<T>(gen).geq(inputA, inputB);
    }

    public static class Evaluator<T>
    extends EvaRunnable<T> {
        T[] inputA;
        T[] inputB;
        T scResult;

        @Override
        public void prepareInput(CompEnv<T> gen) {
            this.inputA = gen.inputOfAlice(new boolean[32]);
            gen.flush();
            this.inputB = gen.inputOfBob(Utils.fromInt(new Integer(this.args[0]), 32));
        }

        @Override
        public void secureCompute(CompEnv<T> gen) {
            this.scResult = Millionaire.compute(gen, this.inputA, this.inputB);
        }

        @Override
        public void prepareOutput(CompEnv<T> gen) throws BadLabelException {
            gen.outputToAlice(this.scResult);
        }
    }

    public static class Generator<T>
    extends GenRunnable<T> {
        T[] inputA;
        T[] inputB;
        T scResult;

        @Override
        public void prepareInput(CompEnv<T> gen) {
            this.inputA = gen.inputOfAlice(Utils.fromInt(new Integer(this.args[0]), 32));
            gen.flush();
            this.inputB = gen.inputOfBob(new boolean[32]);
        }

        @Override
        public void secureCompute(CompEnv<T> gen) {
            this.scResult = Millionaire.compute(gen, this.inputA, this.inputB);
        }

        @Override
        public void prepareOutput(CompEnv<T> gen) throws BadLabelException {
            System.out.println(gen.outputToAlice(this.scResult));
        }
    }
}

