/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.ot;

import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.ot.Cipher;
import com.oblivm.backend.ot.OTSender;
import com.oblivm.backend.rand.ISAACProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;

public class NPOTSender
extends OTSender {
    static SecureRandom rnd;
    private static final int certainty = 80;
    private static final int qLength = 160;
    private static final int pLength = 1024;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger C;
    private BigInteger r;
    private BigInteger Cr;
    private BigInteger gr;
    Cipher cipher;
    GCSignal[][] m = new GCSignal[1][2];

    static {
        Security.addProvider(new ISAACProvider());
        try {
            rnd = SecureRandom.getInstance("ISAACRandom");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public NPOTSender(int msgBitLength, Network channel) throws Exception {
        super(msgBitLength, channel);
        this.cipher = new Cipher();
        this.initialize();
    }

    @Override
    public void send(GCSignal[][] msgPairs) throws IOException {
        this.step1(msgPairs);
    }

    private void initialize() throws Exception {
        File keyfile = new File("NPOTKey");
        if (keyfile.exists()) {
            FileInputStream fin = new FileInputStream(keyfile);
            ObjectInputStream fois = new ObjectInputStream(fin);
            this.C = (BigInteger)fois.readObject();
            this.p = (BigInteger)fois.readObject();
            this.q = (BigInteger)fois.readObject();
            this.g = (BigInteger)fois.readObject();
            this.gr = (BigInteger)fois.readObject();
            this.r = (BigInteger)fois.readObject();
            fois.close();
            Flag.sw.startOTIO();
            this.channel.writeBI(this.C);
            this.channel.writeBI(this.p);
            this.channel.writeBI(this.q);
            this.channel.writeBI(this.g);
            this.channel.writeBI(this.gr);
            this.channel.writeInt(this.msgBitLength);
            this.channel.flush();
            Flag.sw.stopOTIO();
            this.Cr = this.C.modPow(this.r, this.p);
        } else {
            BigInteger pdq;
            this.q = new BigInteger(160, 80, rnd);
            do {
                pdq = new BigInteger(864, rnd);
                pdq = pdq.clearBit(0);
                this.p = this.q.multiply(pdq).add(BigInteger.ONE);
            } while (!this.p.isProbablePrime(80));
            do {
                this.g = new BigInteger(1023, rnd);
            } while (this.g.modPow(pdq, this.p).equals(BigInteger.ONE) || this.g.modPow(this.q, this.p).equals(BigInteger.ONE));
            this.r = new BigInteger(160, rnd).mod(this.q);
            this.gr = this.g.modPow(this.r, this.p);
            this.C = new BigInteger(160, rnd).mod(this.q);
            Flag.sw.startOTIO();
            this.channel.writeBI(this.C);
            this.channel.writeBI(this.p);
            this.channel.writeBI(this.q);
            this.channel.writeBI(this.g);
            this.channel.writeBI(this.gr);
            this.channel.writeInt(this.msgBitLength);
            this.channel.flush();
            Flag.sw.stopOTIO();
            this.Cr = this.C.modPow(this.r, this.p);
            FileOutputStream fout = new FileOutputStream(keyfile);
            ObjectOutputStream foos = new ObjectOutputStream(fout);
            foos.writeObject(this.C);
            foos.writeObject(this.p);
            foos.writeObject(this.q);
            foos.writeObject(this.g);
            foos.writeObject(this.gr);
            foos.writeObject(this.r);
            foos.flush();
            foos.close();
        }
    }

    @Override
    public void send(GCSignal[] msgPair) throws IOException {
        this.m[0][0] = msgPair[0];
        this.m[0][1] = msgPair[1];
        this.send(this.m);
    }

    private void step1(GCSignal[][] msgPairs) throws IOException {
        BigInteger[] pk0 = new BigInteger[msgPairs.length];
        Flag.sw.startOTIO();
        int i = 0;
        while (i < pk0.length) {
            pk0[i] = this.channel.readBI();
            ++i;
        }
        Flag.sw.stopOTIO();
        BigInteger[] pk1 = new BigInteger[msgPairs.length];
        BigInteger[][] msg = new BigInteger[msgPairs.length][2];
        int i2 = 0;
        while (i2 < msgPairs.length) {
            pk0[i2] = pk0[i2].modPow(this.r, this.p);
            pk1[i2] = this.Cr.multiply(pk0[i2].modInverse(this.p)).mod(this.p);
            msg[i2][0] = this.cipher.encrypt(pk0[i2].toByteArray(), new BigInteger(msgPairs[i2][0].bytes), this.msgBitLength);
            msg[i2][1] = this.cipher.encrypt(pk1[i2].toByteArray(), new BigInteger(msgPairs[i2][1].bytes), this.msgBitLength);
            ++i2;
        }
        Flag.sw.startOTIO();
        i2 = 0;
        while (i2 < msg.length) {
            this.channel.writeBI(msg[i2][0]);
            this.channel.writeBI(msg[i2][1]);
            ++i2;
        }
        this.channel.flush();
        Flag.sw.stopOTIO();
    }
}

