/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.helper;

import java.io.PrintWriter;
import java.text.BreakIterator;
import java.util.Collection;
import net.sourceforge.argparse4j.helper.TextWidthCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextHelper {
    private TextHelper() {
    }

    public static <T> String concat(T[] a, int offset, String sep, String start, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        int len = a.length;
        for (int i = offset; i < len; ++i) {
            sb.append(a[i]).append(sep);
        }
        if (sb.length() > sep.length()) {
            sb.delete(sb.length() - sep.length(), sb.length());
        }
        sb.append(end);
        return sb.toString();
    }

    public static <T> String concat(T[] a, int offset, String sep) {
        return TextHelper.concat(a, offset, sep, "", "");
    }

    public static <T> String concat(Collection<T> a, int offset, String sep, String start, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        for (T o : a) {
            sb.append(o).append(sep);
        }
        if (sb.length() > sep.length()) {
            sb.delete(sb.length() - sep.length(), sb.length());
        }
        sb.append(end);
        return sb.toString();
    }

    public static <T> String concat(Collection<T> a, int offset, String sep) {
        return TextHelper.concat(a, offset, sep, "", "");
    }

    public static String wrap(TextWidthCounter textWidthCounter, String s, int width, int initialOffset, String initialIndent, String subsequentIndent) {
        BreakIterator iter = BreakIterator.getLineInstance();
        iter.setText(s);
        StringBuffer sb = new StringBuffer(initialIndent);
        int currentWidth = initialOffset + initialIndent.length();
        int start = iter.first();
        int end = iter.next();
        while (end != -1) {
            String sub = s.substring(start, end);
            int subwidth = textWidthCounter.width(sub);
            if ((currentWidth += subwidth) > width) {
                sb.append("\n").append(subsequentIndent);
                currentWidth = subsequentIndent.length() + subwidth;
            }
            sb.append(sub);
            if (sub.endsWith("\n")) {
                sb.append(subsequentIndent);
                currentWidth = subsequentIndent.length();
            }
            start = end;
            end = iter.next();
        }
        return sb.toString();
    }

    public static void printHelp(PrintWriter writer, String title, String help, TextWidthCounter textWidthCounter, int width) {
        if (textWidthCounter.width(title) <= 21) {
            writer.format("  %-22s %s\n", title, TextHelper.wrap(textWidthCounter, help, width, 25, "", "                         "));
        } else {
            writer.format("  %s\n                         %s\n", title, TextHelper.wrap(textWidthCounter, help, width, 25, "", "                         "));
        }
    }

    public static String nonNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

