/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.circuits;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.util.Utils;
import java.util.Arrays;

public class CircuitLib<T> {
    public CompEnv<T> env;
    public final T SIGNAL_ZERO;
    public final T SIGNAL_ONE;

    public CircuitLib(CompEnv<T> e) {
        this.env = e;
        this.SIGNAL_ZERO = e.ZERO();
        this.SIGNAL_ONE = e.ONE();
    }

    public T[] toSignals(long a, int width) {
        T[] result = this.env.newTArray(width);
        int i = 0;
        while (i < width) {
            result[i] = (a & 1L) == 1L ? this.SIGNAL_ONE : this.SIGNAL_ZERO;
            a >>= 1;
            ++i;
        }
        return result;
    }

    public T[] enforceBits(T[] a, int length) {
        if (length > a.length) {
            return this.padSignal(a, length);
        }
        return Arrays.copyOfRange(a, 0, length);
    }

    public T enforceBits(T a, int length) {
        if (a == null) {
            return this.SIGNAL_ZERO;
        }
        return a;
    }

    public T[] randBools(int length) {
        if (this.env.getMode() == Mode.COUNT) {
            return this.zeros(length);
        }
        boolean[] res = new boolean[length];
        int i = 0;
        while (i < length) {
            res[i] = CompEnv.rnd.nextBoolean();
            ++i;
        }
        T[] alice = this.env.inputOfAlice(res);
        T[] bob = this.env.inputOfBob(res);
        T[] resSC = this.xor(alice, bob);
        return resSC;
    }

    public boolean[] declassifyToAlice(T[] x) {
        return this.env.outputToAlice(x);
    }

    public boolean[] declassifyToBob(T[] x) {
        return this.env.outputToBob(x);
    }

    public boolean[] declassifyToBoth2(T[] x) {
        if (this.env.getMode() == Mode.COUNT) {
            return new boolean[x.length];
        }
        boolean[] pos = this.env.outputToBob(x);
        if (this.env.getParty() == Party.Bob) {
            byte[] tmp = new byte[pos.length];
            int i = 0;
            while (i < pos.length) {
                tmp[i] = (byte)(pos[i] ? 1 : 0);
                ++i;
            }
            this.env.channel.writeByte(tmp, tmp.length);
            this.env.flush();
        } else {
            byte[] tmp = this.env.channel.readBytes(x.length);
            pos = new boolean[x.length];
            int k = 0;
            while (k < tmp.length) {
                pos[k] = tmp[k] - 1 == 0;
                ++k;
            }
        }
        return pos;
    }

    public boolean[] declassifyToBoth(T[] x) {
        if (this.env.getMode() == Mode.COUNT) {
            return new boolean[x.length];
        }
        if (this.env.getMode() == Mode.VERIFY) {
            return Utils.tobooleanArray((Boolean[])x);
        }
        GCSignal[] in = (GCSignal[])x;
        boolean[] pos = new boolean[x.length];
        int i = 0;
        while (i < x.length) {
            if (in[i].isPublic()) {
                pos[i] = in[i].v;
            } else {
                in[i].send(this.env.channel);
            }
            ++i;
        }
        this.env.channel.flush();
        i = 0;
        while (i < x.length) {
            if (!in[i].isPublic()) {
                GCSignal tmp = GCSignal.receive(this.env.channel);
                pos[i] = !tmp.equals(in[i]);
            }
            ++i;
        }
        return pos;
    }

    public T[] toSignals(int value) {
        return this.toSignals(value, 32);
    }

    public GCSignal[] toSignals(GCSignal[] value) {
        return value;
    }

    public T[] zeros(int length) {
        T[] result = this.env.newTArray(length);
        int i = 0;
        while (i < length) {
            result[i] = this.SIGNAL_ZERO;
            ++i;
        }
        return result;
    }

    public T[] ones(int length) {
        T[] result = this.env.newTArray(length);
        int i = 0;
        while (i < length) {
            result[i] = this.SIGNAL_ONE;
            ++i;
        }
        return result;
    }

    public T and(T x, T y) {
        assert (x != null && y != null) : "CircuitLib.and: bad inputs";
        return this.env.and(x, y);
    }

    public T[] and(T[] x, T[] y) {
        assert (x != null && y != null && x.length == y.length) : "CircuitLib.and[]: bad inputs";
        T[] result = this.env.newTArray(x.length);
        int i = 0;
        while (i < x.length) {
            result[i] = this.and(x[i], y[i]);
            ++i;
        }
        return result;
    }

    public T xor(T x, T y) {
        assert (x != null && y != null) : "CircuitLib.xor: bad inputs";
        return this.env.xor(x, y);
    }

    public T[] xor(T[] x, T[] y) {
        assert (x != null && y != null && x.length == y.length) : "CircuitLib.xor[]: bad inputs";
        T[] result = this.env.newTArray(x.length);
        int i = 0;
        while (i < x.length) {
            result[i] = this.xor(x[i], y[i]);
            ++i;
        }
        return result;
    }

    public T not(T x) {
        assert (x != null) : "CircuitLib.not: bad input";
        return this.env.xor(x, this.SIGNAL_ONE);
    }

    public T[] not(T[] x) {
        assert (x != null) : "CircuitLib.not[]: bad input";
        T[] result = this.env.newTArray(x.length);
        int i = 0;
        while (i < x.length) {
            result[i] = this.not(x[i]);
            ++i;
        }
        return result;
    }

    public T or(T x, T y) {
        assert (x != null && y != null) : "CircuitLib.or: bad inputs";
        return this.xor(this.xor(x, y), this.and(x, y));
    }

    public T[] or(T[] x, T[] y) {
        assert (x != null && y != null && x.length == y.length) : "CircuitLib.or[]: bad inputs";
        T[] result = this.env.newTArray(x.length);
        int i = 0;
        while (i < x.length) {
            result[i] = this.or(x[i], y[i]);
            ++i;
        }
        return result;
    }

    public T mux(T x, T y, T c) {
        assert (x != null && y != null && c != null) : "CircuitLib.mux: bad inputs";
        T t = this.xor(x, y);
        t = this.and(t, c);
        T ret = this.xor(t, x);
        return ret;
    }

    public T[] mux(T[] x, T[] y, T c) {
        assert (x != null && y != null && x.length == y.length) : "CircuitLib.mux[]: bad inputs";
        T[] ret = this.env.newTArray(x.length);
        int i = 0;
        while (i < x.length) {
            ret[i] = this.mux(x[i], y[i], c);
            ++i;
        }
        return ret;
    }

    public T[][] mux(T[][] x, T[][] y, T c) {
        assert (x != null && y != null && x.length == y.length) : "CircuitLib.mux[][]: bad inputs";
        T[][] ret = this.env.newTArray(x.length, 1);
        int i = 0;
        while (i < x.length) {
            ret[i] = this.mux(x[i], y[i], c);
            ++i;
        }
        return ret;
    }

    public T[][][] mux(T[][][] x, T[][][] y, T c) {
        assert (x != null && y != null && x.length == y.length) : "CircuitLib.mux[]: bad inputs";
        T[][][] ret = this.env.newTArray(x.length, 1, 1);
        int i = 0;
        while (i < x.length) {
            ret[i] = this.mux(x[i], y[i], c);
            ++i;
        }
        return ret;
    }

    public T[] padSignal(T[] a, int length) {
        T[] res = this.zeros(length);
        int i = 0;
        while (i < a.length && i < length) {
            res[i] = a[i];
            ++i;
        }
        return res;
    }

    public T[] padSignedSignal(T[] a, int length) {
        T[] res = this.env.newTArray(length);
        int i = 0;
        while (i < a.length && i < length) {
            res[i] = a[i];
            ++i;
        }
        i = a.length;
        while (i < length) {
            res[i] = a[a.length - 1];
            ++i;
        }
        return res;
    }

    public T[] copy(T[] x) {
        return Arrays.copyOf(x, x.length);
    }
}

