/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.circuits.arithmetic;

import com.oblivm.backend.circuits.arithmetic.ArithmeticLib;
import com.oblivm.backend.circuits.arithmetic.IntegerLib;
import com.oblivm.backend.flexsc.CompEnv;

public class VectorLib<T> {
    ArithmeticLib<T> lib;
    CompEnv<T> env;

    public VectorLib(CompEnv<T> e, ArithmeticLib<T> lib) {
        this.env = e;
        this.lib = lib;
    }

    public T[][] xor(T[][] a, T[][] b) {
        IntegerLib<T> ilib = new IntegerLib<T>(this.lib.getEnv());
        T[][] res = this.env.newTArray(a.length, 1);
        int i = 0;
        while (i < a.length) {
            res[i] = ilib.xor(a[i], b[i]);
            ++i;
        }
        return res;
    }

    public T[][] add(T[][] a, T[][] b) {
        T[][] res = this.env.newTArray(a.length, 1);
        int i = 0;
        while (i < a.length) {
            res[i] = this.lib.add(a[i], b[i]);
            ++i;
        }
        return res;
    }

    public T[][] sub(T[][] a, T[][] b) {
        T[][] res = this.env.newTArray(a.length, 1);
        int i = 0;
        while (i < a.length) {
            res[i] = this.lib.sub(a[i], b[i]);
            ++i;
        }
        return res;
    }

    public T[] innerProduct(T[][] a, T[][] b) {
        T[] res = this.lib.publicValue(0.0);
        int i = 0;
        while (i < a.length) {
            res = this.lib.add(res, this.lib.multiply(a[i], b[i]));
            ++i;
        }
        return res;
    }

    public T[][] scalarProduct(T[] scalar, T[][] v) {
        T[][] res = this.env.newTArray(v.length, 1);
        int i = 0;
        while (i < v.length) {
            res[i] = this.lib.multiply(scalar, v[i]);
            ++i;
        }
        return res;
    }

    public T[][] projection(T[][] a, T[][] e) {
        T[] ea = this.innerProduct(e, a);
        T[] ee = this.innerProduct(e, e);
        T[] scalar = this.lib.div(ea, ee);
        return this.scalarProduct(scalar, e);
    }

    public T[][] normalize(T[][] vec) {
        T[] scalar = this.innerProduct(vec, vec);
        scalar = this.lib.sqrt(scalar);
        scalar = this.lib.div(this.lib.publicValue(1.0), scalar);
        return this.scalarProduct(scalar, vec);
    }
}

