/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.flexsc;

import com.oblivm.backend.flexsc.BooleanCompEnv;
import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.util.Utils;

public class CVCompEnv
extends BooleanCompEnv {
    public CVCompEnv(Network channel, Party p) {
        super(channel, p, Mode.VERIFY);
        this.party = p;
    }

    @Override
    public Boolean inputOfAlice(boolean in) {
        Boolean res = null;
        res = in;
        if (this.party == Party.Alice) {
            this.channel.writeInt(in ? 1 : 0);
        } else {
            int re = this.channel.readInt();
            res = re == 1;
        }
        this.channel.flush();
        return res;
    }

    @Override
    public Boolean inputOfBob(boolean in) {
        Boolean res = null;
        this.channel.flush();
        res = in;
        if (this.party == Party.Bob) {
            this.channel.writeInt(in ? 1 : 0);
        } else {
            int re = this.channel.readInt();
            res = re == 1;
        }
        this.channel.flush();
        return res;
    }

    @Override
    public boolean outputToAlice(Boolean out) {
        return out;
    }

    @Override
    public boolean outputToBob(Boolean out) {
        return out;
    }

    @Override
    public Boolean and(Boolean a, Boolean b) {
        ++Flag.sw.ands;
        ++this.numOfAnds;
        if (a.booleanValue() && b.booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean xor(Boolean a, Boolean b) {
        return a ^ b;
    }

    @Override
    public Boolean not(Boolean a) {
        return a == false;
    }

    public Boolean[] inputOfAlice(boolean[] in) {
        Boolean[] res = new Boolean[in.length];
        int i = 0;
        while (i < res.length) {
            res[i] = this.inputOfAlice(in[i]);
            ++i;
        }
        return res;
    }

    public Boolean[] inputOfBob(boolean[] in) {
        Boolean[] res = new Boolean[in.length];
        int i = 0;
        while (i < res.length) {
            res[i] = this.inputOfBob(in[i]);
            ++i;
        }
        return res;
    }

    public boolean[] outputToAlice(Boolean[] out) {
        return Utils.tobooleanArray(out);
    }

    public boolean[] outputToBob(Boolean[] out) {
        return Utils.tobooleanArray(out);
    }
}

