/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.circuits.arithmetic.IntegerLib;
import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.util.Utils;

public class LinearScanOram<T> {
    public T[][] content;
    public CompEnv<T> env;
    public int lengthOfIden;
    public IntegerLib<T> lib;
    public int dataSize;

    public LinearScanOram(CompEnv<T> env, int N, int dataSize) {
        this.env = env;
        this.dataSize = dataSize;
        this.lib = new IntegerLib<T>(env);
        this.content = env.newTArray(N, 0);
        this.lengthOfIden = Utils.log2(N);
        int i = 0;
        while (i < N) {
            this.content[i] = this.lib.zeros(dataSize);
            ++i;
        }
    }

    public void add(T[] iden, T[] data, T dummy) {
        T[] iden1 = this.lib.padSignal(iden, this.lengthOfIden);
        int i = 0;
        while (i < this.content.length) {
            T eq = this.lib.eq(iden1, this.lib.toSignals(i, this.lengthOfIden));
            eq = this.lib.and(eq, dummy);
            this.content[i] = this.lib.mux(this.content[i], data, eq);
            ++i;
        }
    }

    public void add(T[] iden, T[] data) {
        T[] iden1 = this.lib.padSignal(iden, this.lengthOfIden);
        int i = 0;
        while (i < this.content.length) {
            T eq = this.lib.eq(iden1, this.lib.toSignals(i, this.lengthOfIden));
            this.content[i] = this.lib.mux(this.content[i], data, eq);
            ++i;
        }
    }

    public T[] readAndRemove(T[] iden) {
        return this.readAndRemove(iden, false);
    }

    public T[] readAndRemove(T[] iden, boolean randomWhennotFound) {
        T[] iden1 = this.lib.padSignal(iden, this.lengthOfIden);
        T[] res = this.lib.zeros(this.content[0].length);
        int i = 0;
        while (i < this.content.length) {
            T eq = this.lib.eq(iden1, this.lib.toSignals(i, this.lengthOfIden));
            res = this.lib.mux(res, this.content[i], eq);
            ++i;
        }
        return res;
    }

    public T[] read(T[] iden) {
        return this.readAndRemove(iden, false);
    }

    public void write(T[] iden, T[] data) {
        this.add(iden, data);
    }

    public void write(T[] iden, T[] data, T dummy) {
        this.add(iden, data, dummy);
    }

    public void putBack(T[] scIden, T[] scData) {
        this.add(scIden, scData);
    }
}

