/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.oram.Block;
import com.oblivm.backend.oram.OramParty;
import com.oblivm.backend.oram.PlainBlock;
import java.util.Arrays;

public class TrivialPrivateOram<T>
extends OramParty<T> {
    public PlainBlock[] bucket;
    Block<T>[] result;
    int capacity;
    int InitialValue = 0;

    public TrivialPrivateOram(CompEnv<T> env, int N, int dataSize) {
        super(env, N, dataSize, 1);
        this.capacity = N;
        this.bucket = new PlainBlock[this.capacity];
        int i = 0;
        while (i < this.bucket.length) {
            this.bucket[i] = this.getDummyBlock(this.p == Party.Alice);
            ++i;
        }
        this.result = this.prepareBlocks(this.bucket, this.bucket);
    }

    public void setInitialValue(int initial) {
        this.InitialValue = initial;
    }

    public void add(T[] iden, T[] data) {
        T[] pos = this.env.newTArray(1);
        pos[0] = this.lib.SIGNAL_ONE;
        Block<Object> scNewBlock = new Block<Object>(iden, pos, data, this.lib.SIGNAL_ZERO);
        this.lib.add(this.result, scNewBlock);
    }

    public T[] readAndRemove(T[] scIden) {
        return this.readAndRemove(scIden, true);
    }

    public T[] readAndRemove(T[] scIden, boolean randomWhennotFound) {
        T[] finalRes;
        scIden = this.lib.padSignal(scIden, this.lengthOfIden);
        Block<T> res = this.lib.readAndRemove(this.result, scIden);
        if (randomWhennotFound) {
            PlainBlock b1 = this.randomBlock();
            Block scb1 = this.inputBlockOfClient(b1);
            finalRes = this.lib.mux(res.data, scb1.data, res.isDummy);
        } else {
            finalRes = this.lib.mux(res.data, this.lib.toSignals(this.InitialValue, res.data.length), res.isDummy);
        }
        return finalRes;
    }

    public T[] read(int index) {
        return this.result[index].data;
    }

    public void write(int index, T[] d) {
        this.result[index].data = d;
    }

    public T[] read(T[] scIden) {
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        T[] r = this.readAndRemove(scIden, false);
        this.putBack(scIden, r);
        return r;
    }

    public void write(T[] scIden, T[] b) {
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        this.readAndRemove(scIden);
        this.putBack(scIden, b);
    }

    public void putBack(T[] scIden, T[] scData) {
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        this.add(scIden, scData);
    }

    public T[] conditionalReadAndRemove(T[] iden, T condition) {
        return this.lib.conditionalReadAndRemove(this.result, iden, condition).data;
    }

    public void conditionalPutBack(T[] iden, T[] data, T condition) {
        T[] pos = this.env.newTArray(1);
        pos[0] = this.lib.SIGNAL_ONE;
        Block<Object> scNewBlock = new Block<Object>(iden, pos, data, this.lib.SIGNAL_ZERO);
        this.lib.conditionalAdd(this.result, scNewBlock, condition);
    }
}

