/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.circuits.BitonicSortLib;
import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.oram.Block;

public class BucketLib<T>
extends BitonicSortLib<T> {
    public Block<T> dummyBlock;
    protected int lengthOfIden;
    protected int lengthOfPos;
    protected int lengthOfData;

    public BucketLib(int lengthOfIden, int lengthOfPos, int lengthOfData, CompEnv<T> e) {
        super(e);
        this.lengthOfData = lengthOfData;
        this.lengthOfIden = lengthOfIden;
        this.lengthOfPos = lengthOfPos;
        this.dummyBlock = new Block<Object>(this.zeros(lengthOfIden), this.zeros(lengthOfPos), this.zeros(lengthOfData), this.SIGNAL_ONE);
    }

    public T isFull(Block<T>[] bucket) {
        Object res = this.SIGNAL_ONE;
        int i = 0;
        while (i < bucket.length) {
            res = this.and(res, this.not(bucket[i].isDummy));
            ++i;
        }
        return (T)res;
    }

    public T isEmpty(Block<T>[] bucket) {
        Object res = this.SIGNAL_ONE;
        int i = 0;
        while (i < bucket.length) {
            res = this.and(res, bucket[i].isDummy);
            ++i;
        }
        return (T)res;
    }

    public Block<T> conditionalReadAndRemove(Block<T>[] bucket, T[] iden, T condition) {
        Block<T> result = this.dummyBlock;
        int i = 0;
        while (i < bucket.length) {
            T match = this.eq(iden, bucket[i].iden);
            match = this.and(match, this.not(bucket[i].isDummy));
            match = this.and(match, condition);
            result = this.mux(result, bucket[i], match);
            bucket[i].isDummy = this.mux(bucket[i].isDummy, this.SIGNAL_ONE, match);
            ++i;
        }
        return result;
    }

    public Block<T> readAndRemove(Block<T>[] bucket, T[] iden) {
        Block<T> result = this.dummyBlock;
        int i = 0;
        while (i < bucket.length) {
            T match = this.eq(iden, bucket[i].iden);
            match = this.and(match, this.not(bucket[i].isDummy));
            result = this.mux(result, bucket[i], match);
            bucket[i].isDummy = this.mux(bucket[i].isDummy, this.SIGNAL_ONE, match);
            ++i;
        }
        return result;
    }

    public Block<T> conditionalReadAndRemove(Block<T>[][] blocks, T[] iden, T condition) {
        Block<T>[] res = this.newBlockArray(blocks.length);
        int i = 0;
        while (i < blocks.length) {
            res[i] = this.conditionalReadAndRemove(blocks[i], iden, condition);
            ++i;
        }
        return this.conditionalReadAndRemove(res, iden, condition);
    }

    public Block<T> readAndRemove(Block<T>[][] blocks, T[] iden) {
        Block<T>[] res = this.newBlockArray(blocks.length);
        int i = 0;
        while (i < blocks.length) {
            res[i] = this.readAndRemove(blocks[i], iden);
            ++i;
        }
        return this.readAndRemove(res, iden);
    }

    public void conditionalAdd(Block<T>[] bucket, Block<T> newBlock, T condition) {
        Object match;
        T added = this.not(condition);
        int i = 0;
        while (i < bucket.length) {
            match = this.and(this.not(bucket[i].isDummy), this.eq(newBlock.iden, bucket[i].iden));
            added = this.or(match, added);
            ++i;
        }
        i = 0;
        while (i < bucket.length) {
            match = bucket[i].isDummy;
            T shouldAdd = this.and(this.not(added), match);
            added = this.or(added, shouldAdd);
            bucket[i] = this.mux(bucket[i], newBlock, shouldAdd);
            ++i;
        }
    }

    public void add(Block<T>[] bucket, Block<T> newBlock) {
        Object match;
        Object added = this.SIGNAL_ZERO;
        int i = 0;
        while (i < bucket.length) {
            match = this.and(this.not(bucket[i].isDummy), this.eq(newBlock.iden, bucket[i].iden));
            added = this.or(match, added);
            ++i;
        }
        i = 0;
        while (i < bucket.length) {
            match = bucket[i].isDummy;
            Object shouldAdd = this.and(this.not(added), match);
            added = this.or(added, shouldAdd);
            bucket[i] = this.mux(bucket[i], newBlock, shouldAdd);
            ++i;
        }
    }

    public Block<T> pop(Block<T>[] bucket) {
        Block<Object> result = this.dummyBlock;
        Object poped = this.SIGNAL_ZERO;
        int i = 0;
        while (i < bucket.length) {
            Object notDummy = this.not(bucket[i].isDummy);
            Object shouldPop = this.and(this.not(poped), notDummy);
            poped = this.or(poped, shouldPop);
            result = this.mux(result, bucket[i], shouldPop);
            bucket[i].isDummy = this.mux(bucket[i].isDummy, this.SIGNAL_ONE, shouldPop);
            ++i;
        }
        return result;
    }

    public Block<T> conditionalPop(Block<T>[] bucket, T condition) {
        Block<T> result = this.dummyBlock;
        T poped = this.not(condition);
        int i = 0;
        while (i < bucket.length) {
            Object notDummy = this.not(bucket[i].isDummy);
            T shouldPop = this.and(this.not(poped), notDummy);
            poped = this.or(poped, shouldPop);
            result = this.mux(result, bucket[i], shouldPop);
            bucket[i].isDummy = this.mux(bucket[i].isDummy, this.SIGNAL_ONE, shouldPop);
            ++i;
        }
        return result;
    }

    @Override
    public Block<T> mux(Block<T> a, Block<T> b, T choose) {
        T[] iden = this.mux(a.iden, b.iden, choose);
        T[] pos = this.mux(a.pos, b.pos, choose);
        T[] data = this.mux(a.data, b.data, choose);
        Object isDummy = this.mux(a.isDummy, b.isDummy, choose);
        return new Block(iden, pos, data, isDummy);
    }

    @Override
    public Block<T> xor(Block<T> a, Block<T> b) {
        T[] iden = this.xor(a.iden, b.iden);
        T[] pos = this.xor(a.pos, b.pos);
        T[] data = this.xor(a.data, b.data);
        Object isDummy = this.xor(a.isDummy, b.isDummy);
        return new Block(iden, pos, data, isDummy);
    }

    @Override
    public Block<T>[] xor(Block<T>[] a, Block<T>[] b) {
        assert (a.length == b.length) : "xor Block<T>s error";
        Block<T>[] result = this.newBlockArray(b.length);
        int i = 0;
        while (i < a.length) {
            result[i] = this.xor(a[i], b[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Block<T>[][] xor(Block<T>[][] a, Block<T>[][] b) {
        assert (a.length == b.length) : "xor Block<T>s error";
        Block<T>[][] result = this.newBlockMatrix(a.length);
        int i = 0;
        while (i < a.length) {
            result[i] = this.newBlockArray(a[i].length);
            int j = 0;
            while (j < a[i].length) {
                result[i][j] = this.xor(a[i][j], b[i][j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Block<T> copy(Block<T> b) {
        return new Block(b.iden, b.pos, b.data, b.isDummy);
    }

    public Block<T>[] newBlockArray(int len) {
        return new Block[len];
    }

    public Block<T>[][] newBlockMatrix(int x, int y) {
        return new Block[x][y];
    }

    public Block<T>[][] newBlockMatrix(int x) {
        return new Block[x][];
    }
}

