/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.ot;

import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.gc.GCGenComp;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.ot.OTExtSender;
import com.oblivm.backend.ot.OTSender;
import java.io.IOException;
import java.util.Arrays;

public class OTPreprocessSender
extends OTSender {
    OTExtSender sender;
    public static final int bufferSize = 0x100000;
    public static final int fillLength = 300000;
    GCSignal[][] buffer = new GCSignal[0x100000][2];
    int bufferusage = 0;

    public OTPreprocessSender(int msgBitLength, Network channel) {
        super(msgBitLength, channel);
        this.sender = new OTExtSender(msgBitLength, channel);
        this.fillup();
    }

    public void fillup() {
        this.channel.flush();
        while (this.bufferusage < 0x100000) {
            int l = Math.min(300000, 0x100000 - this.bufferusage);
            int i = this.bufferusage;
            while (i < this.bufferusage + l) {
                this.buffer[i] = GCGenComp.genPair();
                ++i;
            }
            try {
                this.sender.send((GCSignal[][])Arrays.copyOfRange(this.buffer, this.bufferusage, this.bufferusage + l));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bufferusage += l;
            System.out.println("preprocessing OT" + (double)this.bufferusage / 1048576.0);
        }
        this.channel.flush();
    }

    @Override
    public void send(GCSignal[] m) throws IOException {
        Flag.sw.startOTIO();
        byte z = this.channel.readBytes(1)[0];
        Flag.sw.stopOTIO();
        --this.bufferusage;
        if (z == 0) {
            m[0].xor(this.buffer[this.bufferusage][0]).send(this.channel);
            m[1].xor(this.buffer[this.bufferusage][1]).send(this.channel);
        } else {
            m[0].xor(this.buffer[this.bufferusage][1]).send(this.channel);
            m[1].xor(this.buffer[this.bufferusage][0]).send(this.channel);
        }
        if (this.bufferusage == 0) {
            this.fillup();
        }
    }

    @Override
    public void send(GCSignal[][] m) throws IOException {
        if (this.bufferusage < m.length) {
            this.fillup();
        }
        Flag.sw.startOTIO();
        byte[] z = this.channel.readBytes(m.length);
        Flag.sw.stopOTIO();
        int i = 0;
        while (i < m.length) {
            --this.bufferusage;
            if (z[i] == 0) {
                m[i][0].xor(this.buffer[this.bufferusage][0]).send(this.channel);
                m[i][1].xor(this.buffer[this.bufferusage][1]).send(this.channel);
            } else {
                m[i][0].xor(this.buffer[this.bufferusage][1]).send(this.channel);
                m[i][1].xor(this.buffer[this.bufferusage][0]).send(this.channel);
            }
            ++i;
        }
    }
}

