/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.flexsc;

import com.oblivm.backend.flexsc.CVCompEnv;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.PMCompEnv;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.gc.offline.GCEva;
import com.oblivm.backend.gc.offline.GCGen;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.rand.ISAACProvider;
import com.oblivm.backend.util.Utils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;

public abstract class CompEnv<T> {
    public long numOfAnds = 0L;
    public static SecureRandom rnd;
    public Network channel;
    public Party party;
    public Mode mode;

    static {
        Security.addProvider(new ISAACProvider());
        try {
            rnd = SecureRandom.getInstance("ISAACRandom");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static CompEnv getEnv(Mode mode, Party p, Network w) {
        if (mode == Mode.REAL) {
            if (p == Party.Bob) {
                return new com.oblivm.backend.gc.regular.GCEva(w);
            }
            return new com.oblivm.backend.gc.regular.GCGen(w);
        }
        if (mode == Mode.OPT) {
            if (p == Party.Bob) {
                return new com.oblivm.backend.gc.halfANDs.GCEva(w);
            }
            return new com.oblivm.backend.gc.halfANDs.GCGen(w);
        }
        if (mode == Mode.VERIFY) {
            return new CVCompEnv(w, p);
        }
        if (mode == Mode.COUNT) {
            return new PMCompEnv(w, p);
        }
        if (mode == Mode.OFFLINE) {
            if (p == Party.Bob) {
                return new GCEva(w);
            }
            return new GCGen(w);
        }
        try {
            throw new Exception("not a supported Mode!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CompEnv(Network w, Party p, Mode m) {
        this.channel = w;
        this.mode = m;
        this.party = p;
    }

    public abstract T inputOfAlice(boolean var1);

    public abstract T inputOfBob(boolean var1);

    public abstract boolean outputToAlice(T var1);

    public abstract boolean outputToBob(T var1);

    public abstract T[] inputOfAlice(boolean[] var1);

    public abstract T[] inputOfBob(boolean[] var1);

    public T[][] inputOfAlice(boolean[][] in) {
        boolean[] flattened = Utils.flatten(in);
        T[] res = this.inputOfAlice(flattened);
        T[][] unflattened = this.newTArray(in.length, in[0].length);
        Utils.unflatten(res, unflattened);
        return unflattened;
    }

    public T[][] inputOfBob(boolean[][] in) {
        boolean[] flattened = Utils.flatten(in);
        T[] res = this.inputOfBob(flattened);
        T[][] unflattened = this.newTArray(in.length, in[0].length);
        Utils.unflatten(res, unflattened);
        return unflattened;
    }

    public T[][][] inputOfAlice(boolean[][][] in) {
        boolean[] flattened = Utils.flatten(in);
        T[] res = this.inputOfAlice(flattened);
        T[][][] unflattened = this.newTArray(in.length, in[0].length, in[0][0].length);
        Utils.unflatten(res, unflattened);
        return unflattened;
    }

    public T[][][] inputOfBob(boolean[][][] in) {
        boolean[] flattened = Utils.flatten(in);
        T[] res = this.inputOfBob(flattened);
        T[][][] unflattened = this.newTArray(in.length, in[0].length, in[0][0].length);
        Utils.unflatten(res, unflattened);
        return unflattened;
    }

    public abstract boolean[] outputToAlice(T[] var1);

    public abstract boolean[] outputToBob(T[] var1);

    public abstract T and(T var1, T var2);

    public abstract T xor(T var1, T var2);

    public abstract T not(T var1);

    public abstract T ONE();

    public abstract T ZERO();

    public abstract T[] newTArray(int var1);

    public abstract T[][] newTArray(int var1, int var2);

    public abstract T[][][] newTArray(int var1, int var2, int var3);

    public abstract T newT(boolean var1);

    public Party getParty() {
        return this.party;
    }

    public void flush() {
        this.channel.flush();
    }

    public Mode getMode() {
        return this.mode;
    }
}

