/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.ot;

import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.ot.BitMatrix;
import com.oblivm.backend.ot.Cipher;
import com.oblivm.backend.ot.NPOTReceiver;
import com.oblivm.backend.ot.OTExtReceiver;
import com.oblivm.backend.ot.OTReceiver;
import com.oblivm.backend.ot.OTSender;
import com.oblivm.backend.rand.ISAACProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;

public class OTExtSender
extends OTSender {
    private static SecureRandom rnd;
    private OTReceiver rcver;
    private boolean[] s;
    private GCSignal[] keys;
    Cipher cipher;
    int poolIndex = 0;
    GCSignal[][] keyPairs = new GCSignal[80][2];

    static {
        Security.addProvider(new ISAACProvider());
        try {
            rnd = SecureRandom.getInstance("ISAACRandom");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public OTExtSender(int msgBitLength, Network channel) {
        super(msgBitLength, channel);
        this.cipher = new Cipher();
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(GCSignal[] m) {
        try {
            throw new Exception("It doesn't make sense to do single OT with OT extension!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void send(GCSignal[][] msgPairs) throws IOException {
        GCSignal[][] pairs = new GCSignal[80 + msgPairs.length][2];
        int i = 0;
        while (i < 80) {
            pairs[i][0] = GCSignal.freshLabel(rnd);
            pairs[i][1] = GCSignal.freshLabel(rnd);
            ++i;
        }
        i = 80;
        while (i < pairs.length) {
            pairs[i][0] = msgPairs[i - 80][0];
            pairs[i][1] = msgPairs[i - 80][1];
            ++i;
        }
        OTExtSender.reverseAndExtend(this.s, this.keys, this.msgBitLength, pairs, this.channel, this.cipher);
        i = 0;
        while (i < 80) {
            this.keyPairs[i][0] = pairs[i][0];
            this.keyPairs[i][1] = pairs[i][1];
            ++i;
        }
        i = 0;
        while (i < this.s.length) {
            this.s[i] = rnd.nextBoolean();
            ++i;
        }
        this.keys = OTExtReceiver.reverseAndExtend(this.keyPairs, this.s, 80, this.channel, this.cipher);
    }

    static void reverseAndExtend(boolean[] s, GCSignal[] keys, int msgBitLength, GCSignal[][] msgPairs, Network channel, Cipher cipher) throws IOException {
        BigInteger[][] cphPairs = new BigInteger[80][2];
        Flag.sw.startOTIO();
        int i = 0;
        while (i < 80) {
            cphPairs[i][0] = channel.readBI();
            cphPairs[i][1] = channel.readBI();
            ++i;
        }
        Flag.sw.stopOTIO();
        int numOfPairs = msgPairs.length;
        BitMatrix Q = new BitMatrix(numOfPairs, 80);
        int i2 = 0;
        while (i2 < 80) {
            Q.data[i2] = s[i2] ? cipher.decrypt(keys[i2].bytes, cphPairs[i2][1], numOfPairs) : cipher.decrypt(keys[i2].bytes, cphPairs[i2][0], numOfPairs);
            ++i2;
        }
        BitMatrix tQ = Q.transpose();
        BigInteger biS = OTExtSender.fromBoolArray(s);
        GCSignal[][] y = new GCSignal[numOfPairs][2];
        int i3 = 0;
        while (i3 < numOfPairs) {
            y[i3][0] = cipher.enc(GCSignal.newInstance(tQ.data[i3].toByteArray()), msgPairs[i3][0], i3);
            y[i3][1] = cipher.enc(GCSignal.newInstance(tQ.data[i3].xor(biS).toByteArray()), msgPairs[i3][1], i3);
            y[i3][0].send(channel);
            y[i3][1].send(channel);
            ++i3;
        }
        Flag.sw.startOTIO();
        channel.flush();
        Flag.sw.stopOTIO();
    }

    private void initialize() throws Exception {
        Flag.sw.startOTIO();
        this.channel.writeInt(this.msgBitLength);
        this.channel.flush();
        Flag.sw.stopOTIO();
        this.rcver = new NPOTReceiver(this.channel);
        this.s = new boolean[80];
        int i = 0;
        while (i < this.s.length) {
            this.s[i] = rnd.nextBoolean();
            ++i;
        }
        this.keys = this.rcver.receive(this.s);
    }

    public static BigInteger fromBoolArray(boolean[] a) {
        BigInteger res = BigInteger.ZERO;
        int i = 0;
        while (i < a.length) {
            if (a[i]) {
                res = res.setBit(i);
            }
            ++i;
        }
        return res;
    }

    static class SecurityParameter {
        public static final int k1 = 80;

        SecurityParameter() {
        }
    }
}

