/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.ot;

import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.ot.BitMatrix;
import com.oblivm.backend.ot.Cipher;
import com.oblivm.backend.ot.NPOTSender;
import com.oblivm.backend.ot.OTExtSender;
import com.oblivm.backend.ot.OTReceiver;
import com.oblivm.backend.ot.OTSender;
import com.oblivm.backend.rand.ISAACProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;

public class OTExtReceiver
extends OTReceiver {
    static SecureRandom rnd;
    private int msgBitLength;
    private OTSender snder;
    private GCSignal[][] keyPairs;
    Cipher cipher;
    boolean[] s = new boolean[80];
    GCSignal[] pool;
    int poolIndex = 0;

    static {
        Security.addProvider(new ISAACProvider());
        try {
            rnd = SecureRandom.getInstance("ISAACRandom");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public OTExtReceiver(Network channel) {
        super(channel);
        this.cipher = new Cipher();
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public GCSignal[] receive(boolean[] choices) throws IOException {
        GCSignal[] keys = new GCSignal[80];
        boolean[] c = new boolean[80 + choices.length];
        int i = 0;
        while (i < 80) {
            c[i] = rnd.nextBoolean();
            ++i;
        }
        i = 80;
        while (i < c.length) {
            c[i] = choices[i - 80];
            ++i;
        }
        GCSignal[] received = OTExtReceiver.reverseAndExtend(this.keyPairs, c, this.msgBitLength, this.channel, this.cipher);
        int i2 = 0;
        while (i2 < 80) {
            keys[i2] = received[i2];
            this.s[i2] = c[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 80) {
            this.keyPairs[i2][0] = GCSignal.freshLabel(rnd);
            this.keyPairs[i2][1] = GCSignal.freshLabel(rnd);
            ++i2;
        }
        OTExtSender.reverseAndExtend(this.s, keys, this.msgBitLength, this.keyPairs, this.channel, this.cipher);
        return Arrays.copyOfRange(received, 80, received.length);
    }

    static GCSignal[] reverseAndExtend(GCSignal[][] keyPairs, boolean[] choices, int msgBitLength, Network channel, Cipher cipher) throws IOException {
        BigInteger[][] msgPairs = new BigInteger[80][2];
        BigInteger[][] cphPairs = new BigInteger[80][2];
        BitMatrix T = new BitMatrix(choices.length, 80);
        T.initialize(rnd);
        BigInteger biChoices = OTExtSender.fromBoolArray(choices);
        int i = 0;
        while (i < 80) {
            msgPairs[i][0] = T.data[i];
            msgPairs[i][1] = T.data[i].xor(biChoices);
            cphPairs[i][0] = cipher.encrypt(keyPairs[i][0].bytes, msgPairs[i][0], choices.length);
            cphPairs[i][1] = cipher.encrypt(keyPairs[i][1].bytes, msgPairs[i][1], choices.length);
            channel.writeBI(cphPairs[i][0]);
            channel.writeBI(cphPairs[i][1]);
            ++i;
        }
        Flag.sw.startOTIO();
        channel.flush();
        Flag.sw.stopOTIO();
        BitMatrix tT = T.transpose();
        GCSignal[] res = new GCSignal[choices.length];
        GCSignal[][] y = new GCSignal[choices.length][2];
        int i2 = 0;
        while (i2 < choices.length) {
            y[i2][0] = GCSignal.receive(channel);
            y[i2][1] = GCSignal.receive(channel);
            int sigma = choices[i2] ? 1 : 0;
            res[i2] = cipher.dec(GCSignal.newInstance(tT.data[i2].toByteArray()), y[i2][sigma], i2);
            ++i2;
        }
        return res;
    }

    private void initialize() throws Exception {
        Flag.sw.startOTIO();
        this.msgBitLength = this.channel.readInt();
        Flag.sw.stopOTIO();
        this.snder = new NPOTSender(80, this.channel);
        this.keyPairs = new GCSignal[80][2];
        int i = 0;
        while (i < 80) {
            this.keyPairs[i][0] = GCSignal.freshLabel(rnd);
            this.keyPairs[i][1] = GCSignal.freshLabel(rnd);
            ++i;
        }
        this.snder.send(this.keyPairs);
        this.channel.flush();
    }

    @Override
    public GCSignal receive(boolean c) {
        try {
            throw new Exception("It doesn't make sense to do single OT with OT extension!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

