/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.ArgumentParserImpl;
import net.sourceforge.argparse4j.internal.SubparserImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubparsersImpl
implements Subparsers {
    private ArgumentParserImpl mainParser_;
    private Map<String, SubparserImpl> parsers_ = new LinkedHashMap<String, SubparserImpl>();
    private String help_ = "";
    private String title_ = "";
    private String description_ = "";
    private String dest_ = "";

    public SubparsersImpl(ArgumentParserImpl mainParser) {
        this.mainParser_ = mainParser;
    }

    @Override
    public Subparser addParser(String command) {
        return this.addParser(command, true, "-");
    }

    @Override
    public Subparser addParser(String command, boolean addHelp) {
        return this.addParser(command, addHelp, "-");
    }

    @Override
    public Subparser addParser(String command, boolean addHelp, String prefixChars) {
        if (command == null || command.isEmpty()) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        SubparserImpl parser = new SubparserImpl(this.mainParser_.getProg(), addHelp, prefixChars, this.mainParser_.getTextWidthCounter(), command, this.mainParser_);
        this.parsers_.put(command, parser);
        return parser;
    }

    @Override
    public Subparsers dest(String dest) {
        this.dest_ = TextHelper.nonNull(dest);
        return this;
    }

    @Override
    public Subparsers help(String help) {
        this.help_ = TextHelper.nonNull(help);
        return this;
    }

    @Override
    public Subparsers title(String title) {
        this.title_ = TextHelper.nonNull(title);
        return this;
    }

    public String getTitle() {
        return this.title_;
    }

    @Override
    public Subparsers description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean hasSubCommand() {
        return !this.parsers_.isEmpty();
    }

    public void parseArg(String[] args, int offset, Map<String, Object> opts) throws ArgumentParserException {
        if (this.parsers_.isEmpty()) {
            throw new IllegalArgumentException("too many arguments");
        }
        SubparserImpl ap = this.parsers_.get(args[offset]);
        if (ap == null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
                sb.append("'").append(entry.getKey()).append("', ");
            }
            sb.delete(sb.length() - 2, sb.length());
            throw new ArgumentParserException(String.format("invalid choice: '%s' (choose from %s)", args[offset], sb.toString()));
        }
        ap.parseArgs(args, offset + 1, opts);
        if (!this.dest_.isEmpty()) {
            opts.put(this.dest_, ap.getCommand());
        }
    }

    public String formatShortSyntax() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
            sb.append(entry.getKey()).append(",");
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append("}");
        return sb.toString();
    }

    public void printSubparserHelp(PrintWriter writer) {
        TextHelper.printHelp(writer, this.formatShortSyntax(), this.help_, this.mainParser_.getTextWidthCounter(), 75);
        for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
            entry.getValue().printSubparserHelp(writer);
        }
    }
}

