/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.circuits.arithmetic;

import com.oblivm.backend.circuits.arithmetic.ArithmeticLib;
import com.oblivm.backend.circuits.arithmetic.IntegerLib;
import com.oblivm.backend.circuits.arithmetic.VectorLib;
import com.oblivm.backend.flexsc.CompEnv;

public class DenseMatrixLib<T> {
    public ArithmeticLib<T> lib;
    VectorLib<T> veclib;
    CompEnv<T> env;
    IntegerLib<T> integerlib;

    public DenseMatrixLib(CompEnv<T> e, ArithmeticLib<T> lib) {
        this.env = e;
        this.lib = lib;
        this.integerlib = new IntegerLib<T>(e);
        this.veclib = new VectorLib<T>(e, lib);
    }

    public T[][][] xor(T[][][] a, T[][][] b) {
        T[][][] res = this.env.newTArray(a.length, a[0].length, 1);
        int i = 0;
        while (i < a.length) {
            res[i] = this.veclib.xor(a[i], b[i]);
            ++i;
        }
        return res;
    }

    public T[][][] add(T[][][] a, T[][][] b) {
        T[][][] res = this.env.newTArray(a.length, a[0].length, 1);
        int i = 0;
        while (i < a.length) {
            res[i] = this.veclib.add(a[i], b[i]);
            ++i;
        }
        return res;
    }

    public T[][][] sub(T[][][] a, T[][][] b) {
        T[][][] res = this.env.newTArray(a.length, a[0].length, 1);
        int i = 0;
        while (i < a.length) {
            res[i] = this.veclib.sub(a[i], b[i]);
            ++i;
        }
        return res;
    }

    public T[][][] multiply(T[][][] a, T[][][] b) {
        T[][][] res = this.env.newTArray(a.length, b[0].length, 1);
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b[0].length) {
                res[i][j] = this.lib.multiply(a[i][0], b[0][j]);
                int k = 1;
                while (k < a[0].length) {
                    res[i][j] = this.lib.add(res[i][j], this.lib.multiply(a[i][k], b[k][j]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    public T[][][] transpose(T[][][] a) {
        T[][][] res = this.env.newTArray(a[0].length, a.length, 1);
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                res[j][i] = a[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public T[][][] rref(T[][][] m) {
        T[][][] result = this.env.newTArray(m.length, m[0].length, 1);
        int r = 0;
        while (r < m.length) {
            int c = 0;
            while (c < m[r].length) {
                result[r][c] = m[r][c];
                ++c;
            }
            ++r;
        }
        int p = 0;
        while (p < result.length) {
            T[] pv = result[p][p];
            T pvZero = this.lib.eq(pv, this.lib.publicValue(0.0));
            T[] pvInv = this.lib.div(this.lib.publicValue(1.0), pv);
            int i = 0;
            while (i < result[p].length) {
                result[p][i] = this.integerlib.mux(this.lib.multiply(result[p][i], pvInv), result[p][i], pvZero);
                ++i;
            }
            int r2 = 0;
            while (r2 < result.length) {
                if (r2 != p) {
                    T[] f = result[r2][p];
                    int i2 = 0;
                    while (i2 < result[r2].length) {
                        result[r2][i2] = this.lib.sub(result[r2][i2], this.lib.multiply(f, result[p][i2]));
                        ++i2;
                    }
                }
                ++r2;
            }
            ++p;
        }
        return result;
    }

    public T[][][] fastInverse(T[][][] m) {
        int dimension = m.length;
        T[][][] extended = this.env.newTArray(dimension, dimension * 2, 1);
        T[] zeroFloat = this.lib.publicValue(0.0);
        T[] oneFloat = this.lib.publicValue(1.0);
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                extended[i][j] = m[i][j];
                ++j;
            }
            j = 0;
            while (j < dimension) {
                extended[i][dimension + j] = zeroFloat;
                ++j;
            }
            extended[i][dimension + i] = oneFloat;
            ++i;
        }
        extended = this.rref(extended);
        T[][][] result = this.env.newTArray(dimension, dimension, 1);
        int i2 = 0;
        while (i2 < dimension) {
            int j = 0;
            while (j < dimension) {
                result[i2][j] = extended[i2][dimension + j];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public T[][] solve(T[][][] A, T[][] b) {
        int dimension = A.length;
        T[][][] extended = this.env.newTArray(dimension, dimension + 1, 1);
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                extended[i][j] = A[i][j];
                ++j;
            }
            extended[i][dimension] = b[i];
            ++i;
        }
        extended = this.rref(extended);
        T[][] result = this.env.newTArray(dimension, 1);
        int i2 = 0;
        while (i2 < dimension) {
            result[i2] = extended[i2][dimension];
            ++i2;
        }
        return result;
    }

    public T[][] getColumn(T[][][] matrix, int col) {
        T[][] res = this.env.newTArray(matrix[0].length, 1);
        int i = 0;
        while (i < matrix[0].length) {
            res[i] = matrix[i][col];
            ++i;
        }
        return res;
    }

    public T[][] getRow(T[][][] matrix, int row) {
        T[][] res = this.env.newTArray(matrix.length, 1);
        int i = 0;
        while (i < matrix.length) {
            res[i] = matrix[row][i];
            ++i;
        }
        return res;
    }

    public void QRDecomposition(T[][][] matrix, T[][][] res1, T[][][] res2) {
        T[][][] u = this.env.newTArray(matrix[0].length, matrix.length, 1);
        T[][][] e = this.env.newTArray(matrix[0].length, matrix.length, 1);
        T[][][] a = this.transpose(matrix);
        int i = 0;
        while (i < matrix[0].length) {
            u[i] = a[i];
            int j = 0;
            while (j < i) {
                u[i] = this.veclib.sub(u[i], this.veclib.projection(a[i], e[j]));
                ++j;
            }
            e[i] = this.veclib.normalize(u[i]);
            ++i;
        }
        T[][][] r = this.env.newTArray(matrix.length, matrix[0].length, 1);
        T[] zero = this.lib.publicValue(0.0);
        int i2 = 0;
        while (i2 < r.length) {
            int j = 0;
            while (j < r[0].length) {
                r[i2][j] = i2 <= j ? this.veclib.innerProduct(e[i2], a[j]) : zero;
                ++j;
            }
            ++i2;
        }
        res1 = this.transpose(e);
        res2 = r;
    }

    public T[][][] eigenValues(T[][][] matrix, int numberOfIterations) {
        T[][][] e1 = null;
        T[][][] e2 = null;
        this.QRDecomposition(matrix, e1, e2);
        T[][][] newMatrix = null;
        int i = 0;
        while (i < numberOfIterations) {
            newMatrix = this.multiply(e1, e2);
            this.QRDecomposition(newMatrix, e1, e2);
            ++i;
        }
        return newMatrix;
    }

    public static double[][] rref(double[][] mat) {
        double[][] rref = new double[mat.length][mat[0].length];
        int r = 0;
        while (r < rref.length) {
            int c = 0;
            while (c < rref[r].length) {
                rref[r][c] = mat[r][c];
                ++c;
            }
            ++r;
        }
        int p = 0;
        while (p < rref.length) {
            double pv = rref[p][p];
            if (pv != 0.0) {
                double pvInv = 1.0 / pv;
                int i = 0;
                while (i < rref[p].length) {
                    double[] dArray = rref[p];
                    int n = i++;
                    dArray[n] = dArray[n] * pvInv;
                }
            }
            int r2 = 0;
            while (r2 < rref.length) {
                if (r2 != p) {
                    double f = rref[r2][p];
                    int i = 0;
                    while (i < rref[0].length) {
                        double[] dArray = rref[r2];
                        int n = i;
                        dArray[n] = dArray[n] - f * rref[p][i];
                        ++i;
                    }
                }
                ++r2;
            }
            ++p;
        }
        return rref;
    }
}

