/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.util.Utils;

public class PlainBlock {
    public long iden;
    public long pos;
    public boolean[] data;
    public boolean isDummy;

    public PlainBlock(long iden, long pos, boolean[] data, boolean isDummy) {
        this.iden = iden;
        this.pos = pos;
        this.data = data;
        this.isDummy = isDummy;
    }

    public boolean[] toBooleanArray(int lengthOfIden, int lengthOfPos) {
        boolean[] result = new boolean[lengthOfIden + lengthOfPos + this.data.length + 1];
        System.arraycopy(Utils.fromLong(this.iden, lengthOfIden), 0, result, 0, lengthOfIden);
        System.arraycopy(Utils.fromLong(this.pos, lengthOfIden), 0, result, lengthOfIden, lengthOfPos);
        System.arraycopy(this.data, 0, result, lengthOfPos + lengthOfIden, this.data.length);
        result[result.length - 1] = this.isDummy;
        return result;
    }

    public static boolean[] toBooleanArray(PlainBlock[] blocks, int lengthOfIden, int lengthOfPos) {
        int blockSize = lengthOfIden + lengthOfPos + blocks[0].data.length + 1;
        boolean[] result = new boolean[blockSize * blocks.length];
        int i = 0;
        while (i < blocks.length) {
            boolean[] tmp = blocks[i].toBooleanArray(lengthOfIden, lengthOfPos);
            System.arraycopy(tmp, 0, result, i * blockSize, blockSize);
            ++i;
        }
        return result;
    }
}

