/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.gc.BadLabelException;
import com.oblivm.backend.oram.LinearScanOram;
import com.oblivm.backend.oram.RecursiveCircuitOram;
import java.util.Arrays;

public class SecureArray<T> {
    static final int threshold = 256;
    boolean useTrivialOram = false;
    public LinearScanOram<T> trivialOram = null;
    public RecursiveCircuitOram<T> circuitOram = null;
    public int lengthOfIden;

    public SecureArray(CompEnv<T> env, int N, int dataSize) throws Exception {
        boolean bl = this.useTrivialOram = N <= 256;
        if (this.useTrivialOram) {
            this.trivialOram = new LinearScanOram<T>(env, N, dataSize);
            this.lengthOfIden = this.trivialOram.lengthOfIden;
        } else {
            this.circuitOram = new RecursiveCircuitOram<T>(env, N, dataSize);
            this.lengthOfIden = this.circuitOram.lengthOfIden;
        }
    }

    public T[] readAndRemove(T[] iden) throws BadLabelException {
        return this.circuitOram.clients.get(0).readAndRemove(iden, Arrays.copyOfRange(this.circuitOram.clients.get((int)0).lib.declassifyToBoth(iden), 0, this.circuitOram.clients.get((int)0).lengthOfPos), false);
    }

    public T[] read(T[] iden) throws BadLabelException {
        if (this.useTrivialOram) {
            return this.trivialOram.read(iden);
        }
        return this.circuitOram.read(iden);
    }

    public void write(T[] iden, T[] data) throws Exception {
        if (this.useTrivialOram) {
            this.trivialOram.write(iden, data);
        } else {
            this.circuitOram.write(iden, data);
        }
    }

    public void conditionalWrite(T[] iden, T[] data, T condition) throws BadLabelException {
        if (this.useTrivialOram) {
            T[] readData = this.trivialOram.readAndRemove(iden);
            T[] toAdd = this.trivialOram.lib.mux(readData, data, condition);
            this.trivialOram.putBack(iden, toAdd);
        } else {
            this.circuitOram.access(iden, data, condition);
        }
    }
}

