/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.util;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.network.Client;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.cli.ParseException;

public abstract class EvaRunnable<T>
extends Client
implements Runnable {
    Mode m;
    int port;
    String host;
    protected String[] args;
    public boolean verbose = true;

    public abstract void prepareInput(CompEnv<T> var1) throws Exception;

    public abstract void secureCompute(CompEnv<T> var1) throws Exception;

    public abstract void prepareOutput(CompEnv<T> var1) throws Exception;

    public void setParameter(Mode m, String host, int port, String[] args) {
        this.m = m;
        this.port = port;
        this.host = host;
        this.args = args;
    }

    public void setParameter(Mode m, String host, int port) {
        this.m = m;
        this.port = port;
        this.host = host;
    }

    @Override
    public void run() {
        try {
            if (this.verbose) {
                System.out.println("connecting");
            }
            this.connect(this.host, this.port);
            if (this.verbose) {
                System.out.println("connected");
            }
            CompEnv env = CompEnv.getEnv(this.m, Party.Bob, this);
            double s = System.nanoTime();
            Flag.sw.startTotal();
            this.prepareInput(env);
            this.os.flush();
            this.secureCompute(env);
            this.os.flush();
            this.prepareOutput(env);
            this.os.flush();
            Flag.sw.stopTotal();
            double e = System.nanoTime();
            this.disconnect();
            if (this.verbose) {
                System.out.println("Eva running time:" + (e - s) / 1.0E9);
                System.out.println("Number Of AND Gates:" + env.numOfAnds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) throws InstantiationException, IllegalAccessException, ParseException, ClassNotFoundException {
        File file = new File("Config.conf");
        String host = null;
        int port = 0;
        Mode mode = null;
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                String a = scanner.nextLine();
                String[] content = a.split(":");
                if (content.length != 2) continue;
                if (content[0].equals("Host")) {
                    host = content[1].replace(" ", "");
                    continue;
                }
                if (content[0].equals("Port")) {
                    port = new Integer(content[1].replace(" ", ""));
                    continue;
                }
                if (!content[0].equals("Mode")) continue;
                mode = Mode.getMode(content[1].replace(" ", ""));
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Class<?> clazz = Class.forName(String.valueOf(args[0]) + "$Evaluator");
        EvaRunnable run = (EvaRunnable)clazz.newInstance();
        run.setParameter(mode, host, port, Arrays.copyOfRange(args, 1, args.length));
        run.run();
        if (Flag.CountTime) {
            Flag.sw.print();
        }
        if (Flag.countIO) {
            run.printStatistic();
        }
    }
}

