/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.gc;

import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.gc.GCCompEnv;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.ot.FakeOTReceiver;
import com.oblivm.backend.ot.OTExtReceiver;
import com.oblivm.backend.ot.OTPreprocessReceiver;
import com.oblivm.backend.ot.OTReceiver;
import java.io.IOException;
import java.util.Arrays;

public abstract class GCEvaComp
extends GCCompEnv {
    OTReceiver rcv;
    protected long gid = 0L;

    public GCEvaComp(Network channel, Mode mode) {
        super(channel, Party.Bob, mode);
        this.rcv = Flag.FakeOT ? new FakeOTReceiver(channel) : (Flag.ProprocessOT ? new OTPreprocessReceiver(channel) : new OTExtReceiver(channel));
    }

    @Override
    public GCSignal inputOfAlice(boolean in) {
        Flag.sw.startOT();
        GCSignal signal = GCSignal.receive(this.channel);
        Flag.sw.stopOT();
        return signal;
    }

    @Override
    public GCSignal inputOfBob(boolean in) {
        Flag.sw.startOT();
        GCSignal signal = null;
        try {
            signal = this.rcv.receive(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Flag.sw.stopOT();
        return signal;
    }

    public GCSignal[] inputOfBob(boolean[] x) {
        GCSignal[] ret = new GCSignal[x.length];
        int i = 0;
        while (i < x.length) {
            GCSignal[] tmp = this.inputOfBobInter(Arrays.copyOfRange(x, i, Math.min(i + Flag.OTBlockSize, x.length)));
            System.arraycopy(tmp, 0, ret, i, tmp.length);
            i += Flag.OTBlockSize;
        }
        return ret;
    }

    public GCSignal[] inputOfBobInter(boolean[] x) {
        Flag.sw.startOT();
        GCSignal[] signal = null;
        try {
            signal = this.rcv.receive(x);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Flag.sw.stopOT();
        return signal;
    }

    public GCSignal[] inputOfAlice(boolean[] x) {
        Flag.sw.startOT();
        GCSignal[] result = new GCSignal[x.length];
        int i = 0;
        while (i < x.length) {
            result[i] = GCSignal.receive(this.channel);
            ++i;
        }
        Flag.sw.stopOT();
        return result;
    }

    @Override
    public boolean outputToAlice(GCSignal out) {
        if (!out.isPublic()) {
            out.send(this.channel);
        }
        return false;
    }

    @Override
    public boolean outputToBob(GCSignal out) {
        if (out.isPublic()) {
            return out.v;
        }
        GCSignal lb = GCSignal.receive(this.channel);
        return !lb.equals(out);
    }

    public boolean[] outputToAlice(GCSignal[] out) {
        boolean[] result = new boolean[out.length];
        int i = 0;
        while (i < result.length) {
            if (!out[i].isPublic()) {
                out[i].send(this.channel);
            }
            ++i;
        }
        this.channel.flush();
        i = 0;
        while (i < result.length) {
            result[i] = false;
            ++i;
        }
        return result;
    }

    public boolean[] outputToBob(GCSignal[] out) {
        boolean[] result = new boolean[out.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.outputToBob(out[i]);
            ++i;
        }
        return result;
    }

    @Override
    public GCSignal xor(GCSignal a, GCSignal b) {
        if (a.isPublic() && b.isPublic()) {
            return a.v ^ b.v ? new GCSignal(true) : new GCSignal(false);
        }
        if (a.isPublic()) {
            return a.v ? this.not(b) : b;
        }
        if (b.isPublic()) {
            return b.v ? this.not(a) : a;
        }
        return a.xor(b);
    }

    @Override
    public GCSignal not(GCSignal a) {
        if (a.isPublic()) {
            return !a.v ? new GCSignal(true) : new GCSignal(false);
        }
        return a;
    }
}

