/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.oram.Block;
import com.oblivm.backend.oram.CircuitOramLib;
import com.oblivm.backend.oram.PlainBlock;
import com.oblivm.backend.oram.TreeBasedOramParty;
import java.util.Arrays;

public class CircuitOram<T>
extends TreeBasedOramParty<T> {
    public CircuitOramLib<T> lib;
    Block<T>[] scQueue;
    int cnt = 0;
    public PlainBlock[] queue;
    public int queueCapacity;
    int initalValue = 0;

    boolean[] nextPath() {
        boolean[] res = new boolean[this.logN];
        int temp = this.cnt;
        int i = res.length - 1;
        while (i >= 0) {
            res[i] = (temp & 1) == 1;
            temp >>= 1;
            --i;
        }
        this.cnt = (this.cnt + 1) % this.N;
        return res;
    }

    public CircuitOram(CompEnv<T> env, int N, int dataSize, int cap, int sp) {
        super(env, N, dataSize, cap);
        this.lib = new CircuitOramLib<T>(this.lengthOfIden, this.lengthOfPos, this.lengthOfData, this.logN, this.capacity, env);
        this.queueCapacity = 30;
        this.queue = new PlainBlock[this.queueCapacity];
        int i = 0;
        while (i < this.queue.length) {
            this.queue[i] = this.getDummyBlock(this.p == Party.Alice);
            ++i;
        }
        this.scQueue = this.prepareBlocks(this.queue, this.queue);
    }

    public CircuitOram(CompEnv<T> env, int N, int dataSize) {
        super(env, N, dataSize, 3);
        this.lib = new CircuitOramLib<T>(this.lengthOfIden, this.lengthOfPos, this.lengthOfData, this.logN, this.capacity, env);
        this.queueCapacity = 30;
        this.queue = new PlainBlock[this.queueCapacity];
        int i = 0;
        while (i < this.queue.length) {
            this.queue[i] = this.getDummyBlock(this.p == Party.Alice);
            ++i;
        }
        this.scQueue = this.prepareBlocks(this.queue, this.queue);
    }

    protected void ControlEviction() {
        this.flushOneTime(this.nextPath());
        this.flushOneTime(this.nextPath());
    }

    public void flushOneTime(boolean[] pos) {
        PlainBlock[][] blocks = this.getPath(pos);
        Block<T>[][] scPath = this.preparePath(blocks, blocks);
        this.lib.flush(scPath, pos, this.scQueue);
        blocks = this.preparePlainPath(scPath);
        this.putPath(blocks, pos);
    }

    public void setInitialValue(int intial) {
        this.initalValue = intial;
    }

    public T[] readAndRemove(T[] scIden, boolean[] pos, boolean RandomWhenNotFound) {
        PlainBlock[][] blocks = this.getPath(pos);
        Block<T>[][] scPath = this.preparePath(blocks, blocks);
        Block res = this.lib.readAndRemove(scPath, scIden);
        Block<T> res2 = this.lib.readAndRemove(this.scQueue, scIden);
        res = this.lib.mux(res, res2, res.isDummy);
        blocks = this.preparePlainPath(scPath);
        this.putPath(blocks, pos);
        if (RandomWhenNotFound) {
            PlainBlock b = this.randomBlock();
            Block scb = this.inputBlockOfClient(b);
            Block finalRes = this.lib.mux(res, scb, res.isDummy);
            return finalRes.data;
        }
        return this.lib.mux(res.data, this.lib.toSignals(this.initalValue, res.data.length), res.isDummy);
    }

    public void putBack(T[] scIden, T[] scNewPos, T[] scData) {
        Block<Object> b = new Block<Object>(scIden, scNewPos, scData, this.lib.SIGNAL_ZERO);
        this.lib.add(this.scQueue, b);
        this.env.flush();
        this.ControlEviction();
    }

    public T[] read(T[] scIden, boolean[] pos, T[] scNewPos) {
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        T[] r = this.readAndRemove(scIden, pos, false);
        this.putBack(scIden, scNewPos, r);
        return r;
    }

    public void write(T[] scIden, boolean[] pos, T[] scNewPos, T[] scData) {
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        this.readAndRemove(scIden, pos, false);
        this.putBack(scIden, scNewPos, scData);
    }

    public void write(T[] scIden, T[] pos, T[] scNewPos, T[] scData, T dummy) {
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        this.conditionalReadAndRemove(scIden, pos, dummy);
        this.conditionalPutBack(scIden, scNewPos, scData, dummy);
    }

    public T[] access(T[] scIden, boolean[] pos, T[] scNewPos, T[] scData, T op) {
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        T[] r = this.readAndRemove(scIden, pos, false);
        T[] toWrite = this.lib.mux(r, scData, op);
        this.putBack(scIden, scNewPos, toWrite);
        return toWrite;
    }

    public T[] conditionalReadAndRemove(T[] scIden, T[] pos, T condition) {
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        T[] scPos = Arrays.copyOf(pos, this.lengthOfPos);
        T[] randbools = this.lib.randBools(scPos.length);
        T[] posToUse = this.lib.mux(randbools, scPos, condition);
        boolean[] path = this.lib.declassifyToBoth(posToUse);
        PlainBlock[][] blocks = this.getPath(path);
        Block<T>[][] scPath = this.preparePath(blocks, blocks);
        Block res = this.lib.conditionalReadAndRemove(scPath, scIden, condition);
        Block<T> res2 = this.lib.conditionalReadAndRemove(this.scQueue, scIden, condition);
        res = this.lib.mux(res, res2, res.isDummy);
        blocks = this.preparePlainPath(scPath);
        this.putPath(blocks, path);
        this.env.flush();
        return this.lib.mux(res.data, this.lib.toSignals(this.initalValue, res.data.length), res.isDummy);
    }

    public void conditionalPutBack(T[] scIden, T[] scNewPos, T[] scData, T condition) {
        this.env.flush();
        scIden = Arrays.copyOf(scIden, this.lengthOfIden);
        Block<Object> b = new Block<Object>(scIden, scNewPos, scData, this.lib.SIGNAL_ZERO);
        this.lib.conditionalAdd(this.scQueue, b, condition);
        this.env.flush();
        this.ControlEviction();
    }
}

