/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.ot;

import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.ot.Cipher;
import com.oblivm.backend.ot.OTReceiver;
import com.oblivm.backend.rand.ISAACProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;

public class NPOTReceiver
extends OTReceiver {
    static SecureRandom rnd;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger C;
    private BigInteger gr;
    private BigInteger[][] pk;
    private BigInteger[] keys;
    Cipher cipher = new Cipher();

    static {
        Security.addProvider(new ISAACProvider());
        try {
            rnd = SecureRandom.getInstance("ISAACRandom");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public NPOTReceiver(Network channel) throws Exception {
        super(channel);
        this.initialize();
    }

    @Override
    public GCSignal receive(boolean c) throws IOException {
        return this.receive(new boolean[]{c})[0];
    }

    @Override
    public GCSignal[] receive(boolean[] choices) throws IOException {
        this.step1(choices);
        return this.step2(choices);
    }

    private void initialize() throws Exception {
        Flag.sw.startOTIO();
        this.C = this.channel.readBI();
        this.p = this.channel.readBI();
        this.q = this.channel.readBI();
        this.g = this.channel.readBI();
        this.gr = this.channel.readBI();
        this.msgBitLength = this.channel.readInt();
        Flag.sw.stopOTIO();
    }

    private void step1(boolean[] choices) throws IOException {
        this.keys = new BigInteger[choices.length];
        this.pk = new BigInteger[choices.length][2];
        BigInteger[] pk0 = new BigInteger[choices.length];
        int i = 0;
        while (i < choices.length) {
            BigInteger k = new BigInteger(this.q.bitLength(), rnd).mod(this.q);
            BigInteger gk = this.g.modPow(k, this.p);
            BigInteger C_over_gk = this.C.multiply(gk.modInverse(this.p)).mod(this.p);
            this.keys[i] = this.gr.modPow(k, this.p);
            int sigma = choices[i] ? 1 : 0;
            this.pk[i][sigma] = gk;
            this.pk[i][1 - sigma] = C_over_gk;
            pk0[i] = this.pk[i][0];
            ++i;
        }
        Flag.sw.startOTIO();
        i = 0;
        while (i < choices.length) {
            this.channel.writeBI(pk0[i]);
            ++i;
        }
        this.channel.flush();
        Flag.sw.stopOTIO();
    }

    private GCSignal[] step2(boolean[] choices) {
        BigInteger[][] msg = new BigInteger[choices.length][2];
        Flag.sw.startOTIO();
        int i = 0;
        while (i < choices.length) {
            msg[i][0] = this.channel.readBI();
            msg[i][1] = this.channel.readBI();
            ++i;
        }
        Flag.sw.stopOTIO();
        GCSignal[] data = new GCSignal[choices.length];
        int i2 = 0;
        while (i2 < choices.length) {
            int sigma = choices[i2] ? 1 : 0;
            data[i2] = GCSignal.newInstance(this.cipher.decrypt(this.keys[i2].toByteArray(), msg[i2][sigma], this.msgBitLength).toByteArray());
            ++i2;
        }
        return data;
    }
}

