/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.gc.GCCompEnv;
import com.oblivm.backend.oram.Block;
import com.oblivm.backend.oram.BucketLib;
import com.oblivm.backend.util.Utils;

public class CircuitOramLib<T>
extends BucketLib<T> {
    int logN;
    int loglogN;
    int capacity;

    public CircuitOramLib(int lengthOfIden, int lengthOfPos, int lengthOfData, int logN, int capacity, CompEnv<T> e) {
        super(lengthOfIden, lengthOfPos, lengthOfData, e);
        this.logN = logN;
        this.capacity = capacity;
    }

    public T[] deepestLevellocal(T[] pos, T[] path) {
        T[] xored = this.xor(pos, path);
        return this.leadingZeros(xored);
    }

    public T[][] deepestBlockShort(Block<T>[] bucket, T[] pathSignal) {
        T[][] deepest = this.env.newTArray(bucket.length, 0);
        int j = 0;
        while (j < bucket.length) {
            deepest[j] = this.deepestLevellocal(bucket[j].pos, pathSignal);
            ++j;
        }
        T[] maxIden = bucket[0].iden;
        T[] maxdepth = deepest[0];
        Object isDummy = bucket[0].isDummy;
        int j2 = 1;
        while (j2 < bucket.length) {
            Object greater = this.geq(deepest[j2], maxdepth);
            greater = this.and(greater, this.not(bucket[j2].isDummy));
            maxIden = this.mux(maxIden, bucket[j2].iden, greater);
            maxdepth = this.mux(maxdepth, deepest[j2], greater);
            isDummy = this.mux(isDummy, bucket[j2].isDummy, greater);
            ++j2;
        }
        T[][] result = this.env.newTArray(3, 0);
        result[0] = maxIden;
        result[1] = maxdepth;
        result[2] = this.env.newTArray(1);
        result[2][0] = isDummy;
        return result;
    }

    public void flush(Block<T>[][] scPath, boolean[] path, Block<T>[] scQueue) {
        T[] pathSignal = this.env.newTArray(path.length);
        int i = 0;
        while (i < path.length) {
            pathSignal[i] = path[i] ? this.SIGNAL_ONE : this.SIGNAL_ZERO;
            ++i;
        }
        T[][] stashDeepest = this.deepestBlockShort(scQueue, pathSignal);
        this.loglogN = stashDeepest[1].length;
        T[][] deepest = this.env.newTArray(scPath.length + 1, 0);
        T[][] deepestIden = this.env.newTArray(scPath.length + 1, 0);
        int i2 = 0;
        while (i2 < deepest.length) {
            deepest[i2] = this.zeros(this.loglogN);
            deepestIden[i2] = this.zeros(this.lengthOfIden);
            ++i2;
        }
        T[] deepestBot = this.ones(scPath.length + 1);
        T[] cur = this.zeros(this.loglogN);
        Object curBot = this.SIGNAL_ONE;
        T[] curv = stashDeepest[1];
        deepestIden[0] = stashDeepest[0];
        curBot = stashDeepest[2][0];
        int i3 = 0;
        while (i3 < this.logN) {
            T[] iSignal = this.toSignals(i3 + 1, this.loglogN);
            T curvGEQI = this.geq(curv, iSignal);
            deepest[i3 + 1] = this.mux(deepest[i3 + 1], cur, curvGEQI);
            deepestBot[i3 + 1] = this.mux(deepestBot[i3 + 1], curBot, curvGEQI);
            T[][] pathiDeepest = this.deepestBlockShort(scPath[i3], pathSignal);
            deepestIden[i3 + 1] = pathiDeepest[0];
            Object lGcurv = this.not(this.leq(pathiDeepest[1], curv));
            lGcurv = this.and(lGcurv, this.not(pathiDeepest[2][0]));
            lGcurv = this.or(lGcurv, curBot);
            curv = this.mux(curv, pathiDeepest[1], lGcurv);
            cur = this.mux(cur, iSignal, lGcurv);
            curBot = this.mux(curBot, this.SIGNAL_ZERO, lGcurv);
            ++i3;
        }
        Object[] c = this.toSignals(0L, this.loglogN);
        Object cBot = this.SIGNAL_ONE;
        Object[] l = this.toSignals(0L, this.loglogN);
        Object lBot = this.SIGNAL_ONE;
        T[][] target = this.env.newTArray(scPath.length + 1, 0);
        int i4 = 0;
        while (i4 < target.length) {
            target[i4] = this.zeros(this.loglogN);
            ++i4;
        }
        T[] targetBot = this.ones(scPath.length + 1);
        int i5 = this.logN;
        while (i5 >= 0) {
            T[] iSignal = this.toSignals(i5, curv.length);
            Object iEQl = this.and(this.not(lBot), this.eq(iSignal, l));
            T isFull = i5 > 0 ? this.isFull(scPath[i5 - 1]) : this.isFull(scQueue);
            Object hasSlot = this.or(this.and(cBot, this.not(isFull)), this.not(targetBot[i5]));
            Object canPush = this.not(deepestBot[i5]);
            target[i5] = this.mux(target[i5], c, iEQl);
            targetBot[i5] = this.mux(targetBot[i5], cBot, iEQl);
            if (i5 > 0) {
                cBot = this.mux(cBot, this.SIGNAL_ONE, iEQl);
                lBot = this.mux(lBot, this.SIGNAL_ONE, iEQl);
                Object secondIf = this.and(hasSlot, canPush);
                l = this.mux(l, deepest[i5], secondIf);
                lBot = this.mux(lBot, deepestBot[i5], secondIf);
                c = this.mux(c, iSignal, secondIf);
                cBot = this.mux(cBot, this.SIGNAL_ZERO, secondIf);
            }
            --i5;
        }
        Block<T> hold = this.dummyBlock;
        lBot = this.SIGNAL_ONE;
        Object toRemove = this.not(targetBot[0]);
        hold = this.conditionalReadAndRemove(scQueue, deepestIden[0], toRemove);
        l = this.mux(l, target[0], toRemove);
        lBot = this.mux(lBot, targetBot[0], toRemove);
        int i6 = 0;
        while (i6 < this.logN) {
            T[] iSignal = this.toSignals(i6 + 1, curv.length);
            Object iEQl = this.eq(iSignal, l);
            iEQl = this.and(iEQl, this.not(lBot));
            Object firstIf = this.and(this.not(hold.isDummy), iEQl);
            Block<T> holdTmp = this.copy(hold);
            hold.isDummy = this.mux(hold.isDummy, this.SIGNAL_ONE, firstIf);
            lBot = this.mux(lBot, this.SIGNAL_ONE, firstIf);
            Object notBot = this.not(targetBot[i6 + 1]);
            if (i6 != this.logN - 1) {
                Block<T> tmp = this.conditionalReadAndRemove(scPath[i6], deepestIden[i6 + 1], notBot);
                hold = this.mux(hold, tmp, notBot);
            }
            l = this.mux(l, target[i6 + 1], notBot);
            lBot = this.mux(lBot, targetBot[i6 + 1], notBot);
            this.conditionalAdd(scPath[i6], holdTmp, firstIf);
            ++i6;
        }
    }

    public void print(T[][] data, T[] bot) {
        if (this.env.getParty() == Party.Bob || this.env instanceof GCCompEnv) {
            return;
        }
        int i = 0;
        while (i < data.length) {
            if (((Boolean)bot[i]).booleanValue()) {
                System.out.print("d ");
            } else {
                System.out.print(String.valueOf(Utils.toInt(Utils.tobooleanArray((Boolean[])data[i]))) + " ");
            }
            ++i;
        }
        System.out.print("\n");
    }

    public void print(T[] data, T bot) {
        if (this.env.getParty() == Party.Bob || this.env instanceof GCCompEnv) {
            return;
        }
        if (((Boolean)bot).booleanValue()) {
            System.out.print("d ");
        } else {
            System.out.print(String.valueOf(Utils.toInt(Utils.tobooleanArray((Boolean[])data))) + " ");
        }
        System.out.print("\n");
    }

    public void print(String s, T[] data, T bot) {
        if (this.env.getParty() == Party.Bob) {
            return;
        }
        System.out.print(s);
        if (((Boolean)bot).booleanValue()) {
            System.out.print("d ");
        } else {
            System.out.print(String.valueOf(Utils.toInt(Utils.tobooleanArray((Boolean[])data))) + " ");
        }
        System.out.print("\n");
    }
}

