/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.gc.offline;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.gc.GCGenComp;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.gc.offline.FileReader;
import com.oblivm.backend.gc.offline.Garbler;
import com.oblivm.backend.network.Network;
import java.io.BufferedOutputStream;
import java.io.IOException;

public class GCGen
extends GCGenComp {
    Garbler gb;
    public static BufferedOutputStream fout = null;
    public static FileReader fread = null;
    private GCSignal[][] gtt = new GCSignal[2][2];
    private GCSignal[] labelL = new GCSignal[2];
    private GCSignal[] labelR = new GCSignal[2];
    GCSignal[] lb = new GCSignal[2];
    public double t;

    public GCGen(Network channel) {
        super(channel, Mode.OFFLINE);
        this.gtt[0][1] = GCSignal.freshLabel(CompEnv.rnd);
        this.gtt[1][0] = GCSignal.freshLabel(CompEnv.rnd);
        this.gtt[1][1] = GCSignal.freshLabel(CompEnv.rnd);
        this.gb = new Garbler();
    }

    private GCSignal garble(GCSignal a, GCSignal b) {
        this.labelL[0] = a;
        this.labelL[1] = R.xor(this.labelL[0]);
        this.labelR[0] = b;
        this.labelR[1] = R.xor(this.labelR[0]);
        int cL = a.getLSB();
        int cR = b.getLSB();
        this.lb[cL & cR] = this.gb.enc(this.labelL[cL], this.labelR[cR], this.gid, GCSignal.ZERO);
        this.lb[1 - (cL & cR)] = R.xor(this.lb[cL & cR]);
        this.gtt[cL][cR] = this.lb[0];
        this.gtt[cL][1 ^ cR] = this.lb[0];
        this.gtt[1 ^ cL][cR] = this.lb[0];
        this.gtt[1 ^ cL][1 ^ cR] = this.lb[1];
        if (cL != 0 || cR != 0) {
            this.gtt[cL][cR] = this.gb.enc(this.labelL[0], this.labelR[0], this.gid, this.gtt[cL][cR]);
        }
        if (cL != 0 || cR != 1) {
            this.gtt[cL][1 ^ cR] = this.gb.enc(this.labelL[0], this.labelR[1], this.gid, this.gtt[cL][1 ^ cR]);
        }
        if (cL != 1 || cR != 0) {
            this.gtt[1 ^ cL][cR] = this.gb.enc(this.labelL[1], this.labelR[0], this.gid, this.gtt[1 ^ cL][cR]);
        }
        if (cL != 1 || cR != 1) {
            this.gtt[1 ^ cL][1 ^ cR] = this.gb.enc(this.labelL[1], this.labelR[1], this.gid, this.gtt[1 ^ cL][1 ^ cR]);
        }
        return this.lb[0];
    }

    private GCSignal readGateFromFile() {
        fread.read(this.gtt[0][1].bytes);
        fread.read(this.gtt[1][0].bytes);
        fread.read(this.gtt[1][1].bytes);
        GCSignal a = new GCSignal(fread.read(10));
        return a;
    }

    private void writeGateToFile(GCSignal a) {
        this.gtt[0][1].send(fout);
        this.gtt[1][0].send(fout);
        this.gtt[1][1].send(fout);
        a.send(fout);
        try {
            fout.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendGTT() {
        try {
            Flag.sw.startGCIO();
            this.gtt[0][1].send(this.channel);
            this.gtt[1][0].send(this.channel);
            this.gtt[1][1].send(this.channel);
            Flag.sw.stopGCIO();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public GCSignal and(GCSignal a, GCSignal b) {
        Flag.sw.startGC();
        GCSignal res = null;
        if (a.isPublic() && b.isPublic()) {
            res = a.v && b.v ? new GCSignal(true) : new GCSignal(false);
        } else if (a.isPublic()) {
            res = a.v ? b : new GCSignal(false);
        } else if (b.isPublic()) {
            res = b.v ? a : new GCSignal(false);
        } else {
            ++this.numOfAnds;
            if (Flag.offline) {
                res = this.readGateFromFile();
            } else {
                res = this.garble(a, b);
                this.writeGateToFile(res);
                if (this.gid % 100000L == 0L) {
                    System.out.println(this.gid);
                }
            }
            this.sendGTT();
            ++this.gid;
            this.gatesRemain = true;
        }
        Flag.sw.stopGC();
        return res;
    }
}

