/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.circuits;

import com.oblivm.backend.circuits.arithmetic.IntegerLib;
import com.oblivm.backend.flexsc.CompEnv;

public class BitonicSortLib<T>
extends IntegerLib<T> {
    public BitonicSortLib(CompEnv<T> e) {
        super(e);
    }

    public void sortWithPayload(T[][] a, T[][] data, T isAscending) {
        this.bitonicSortWithPayload(a, data, 0, a.length, isAscending);
    }

    private void bitonicSortWithPayload(T[][] key, T[][] data, int lo, int n, T dir) {
        if (n > 1) {
            int m = n / 2;
            this.bitonicSortWithPayload(key, data, lo, m, this.not(dir));
            this.bitonicSortWithPayload(key, data, lo + m, n - m, dir);
            this.bitonicMergeWithPayload(key, data, lo, n, dir);
        }
    }

    protected void bitonicMergeWithPayload(T[][] key, T[][] data, int lo, int n, T dir) {
        if (n > 1) {
            int m = this.greatestPowerOfTwoLessThan(n);
            int i = lo;
            while (i < lo + n - m) {
                this.compareWithPayload(key, data, i, i + m, dir);
                ++i;
            }
            this.bitonicMergeWithPayload(key, data, lo, m, dir);
            this.bitonicMergeWithPayload(key, data, lo + m, n - m, dir);
        }
    }

    private void compareWithPayload(T[][] key, T[][] data, int i, int j, T dir) {
        T greater = this.not(this.leq(key[i], key[j]));
        T swap = this.eq(greater, dir);
        T[] s = this.mux(key[j], key[i], swap);
        s = this.xor(s, key[i]);
        T[] ki = this.xor(key[j], s);
        T[] kj = this.xor(key[i], s);
        key[i] = ki;
        key[j] = kj;
        T[] s2 = this.mux(data[j], data[i], swap);
        s2 = this.xor(s2, data[i]);
        T[] di = this.xor(data[j], s2);
        T[] dj = this.xor(data[i], s2);
        data[i] = di;
        data[j] = dj;
    }

    public void sort(T[][] a, T isAscending) {
        this.bitonicSort(a, 0, a.length, isAscending);
    }

    private void bitonicSort(T[][] key, int lo, int n, T dir) {
        if (n > 1) {
            int m = n / 2;
            this.bitonicSort(key, lo, m, this.not(dir));
            this.bitonicSort(key, lo + m, n - m, dir);
            this.bitonicMerge(key, lo, n, dir);
        }
    }

    protected void bitonicMerge(T[][] key, int lo, int n, T dir) {
        if (n > 1) {
            int m = this.greatestPowerOfTwoLessThan(n);
            int i = lo;
            while (i < lo + n - m) {
                this.compare(key, i, i + m, dir);
                ++i;
            }
            this.bitonicMerge(key, lo, m, dir);
            this.bitonicMerge(key, lo + m, n - m, dir);
        }
    }

    private void compare(T[][] key, int i, int j, T dir) {
        T swap = this.eq(this.not(this.leq(key[i], key[j])), dir);
        T[] s = this.mux(key[j], key[i], swap);
        s = this.xor(s, key[i]);
        T[] ki = this.xor(key[j], s);
        T[] kj = this.xor(key[i], s);
        key[i] = ki;
        key[j] = kj;
    }

    private int greatestPowerOfTwoLessThan(int n) {
        int k = 1;
        while (k < n) {
            k <<= 1;
        }
        return k >> 1;
    }

    public void sortWithPayload(T[] a, T[][] data, T isAscending) {
        this.bitonicSortWithPayload(a, data, 0, a.length, isAscending);
    }

    private void bitonicSortWithPayload(T[] key, T[][] data, int lo, int n, T dir) {
        if (n > 1) {
            int m = n / 2;
            this.bitonicSortWithPayload(key, data, lo, m, this.not(dir));
            this.bitonicSortWithPayload(key, data, lo + m, n - m, dir);
            this.bitonicMergeWithPayload(key, data, lo, n, dir);
        }
    }

    private void bitonicMergeWithPayload(T[] key, T[][] data, int lo, int n, T dir) {
        if (n > 1) {
            int m = this.greatestPowerOfTwoLessThan(n);
            int i = lo;
            while (i < lo + n - m) {
                this.compareWithPayload(key, data, i, i + m, dir);
                ++i;
            }
            this.bitonicMergeWithPayload(key, data, lo, m, dir);
            this.bitonicMergeWithPayload(key, data, lo + m, n - m, dir);
        }
    }

    private void compareWithPayload(T[] key, T[][] data, int i, int j, T dir) {
        T greater = this.and(key[i], this.not(key[j]));
        T swap = this.eq(greater, dir);
        T s = this.mux(key[j], key[i], swap);
        s = this.xor(s, key[i]);
        T ki = this.xor(key[j], s);
        T kj = this.xor(key[i], s);
        key[i] = ki;
        key[j] = kj;
        T[] s2 = this.mux(data[j], data[i], swap);
        s2 = this.xor(s2, data[i]);
        T[] di = this.xor(data[j], s2);
        T[] dj = this.xor(data[i], s2);
        data[i] = di;
        data[j] = dj;
    }

    public void sortWithPayload(T[][] a, T[] data, T isAscending) {
        this.bitonicSortWithPayload(a, data, 0, a.length, isAscending);
    }

    private void bitonicSortWithPayload(T[][] key, T[] data, int lo, int n, T dir) {
        if (n > 1) {
            int m = n / 2;
            this.bitonicSortWithPayload(key, data, lo, m, this.not(dir));
            this.bitonicSortWithPayload(key, data, lo + m, n - m, dir);
            this.bitonicMergeWithPayload(key, data, lo, n, dir);
        }
    }

    private void bitonicMergeWithPayload(T[][] key, T[] data, int lo, int n, T dir) {
        if (n > 1) {
            int m = this.greatestPowerOfTwoLessThan(n);
            int i = lo;
            while (i < lo + n - m) {
                this.compareWithPayload(key, data, i, i + m, dir);
                ++i;
            }
            this.bitonicMergeWithPayload(key, data, lo, m, dir);
            this.bitonicMergeWithPayload(key, data, lo + m, n - m, dir);
        }
    }

    private void compareWithPayload(T[][] key, T[] data, int i, int j, T dir) {
        T greater = this.not(this.leq(key[i], key[j]));
        T swap = this.eq(greater, dir);
        T[] s = this.mux(key[j], key[i], swap);
        s = this.xor(s, key[i]);
        T[] ki = this.xor(key[j], s);
        T[] kj = this.xor(key[i], s);
        key[i] = ki;
        key[j] = kj;
        T s2 = this.mux(data[j], data[i], swap);
        s2 = this.xor(s2, data[i]);
        T di = this.xor(data[j], s2);
        T dj = this.xor(data[i], s2);
        data[i] = di;
        data[j] = dj;
    }
}

