/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.circuits.arithmetic;

import com.oblivm.backend.circuits.arithmetic.ArithmeticLib;
import com.oblivm.backend.circuits.arithmetic.FloatLib;
import com.oblivm.backend.circuits.arithmetic.IntegerLib;
import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.util.Utils;
import java.util.Arrays;

public class FixedPointLib<T>
implements ArithmeticLib<T> {
    CompEnv<T> env;
    IntegerLib<T> lib;
    int offset;
    int width;

    public FixedPointLib(CompEnv<T> e, int width, int offset) {
        assert (offset % 2 == 0);
        this.env = e;
        this.lib = new IntegerLib<T>(e);
        this.offset = offset;
        this.width = width;
    }

    @Override
    public T[] inputOfAlice(double d) {
        return this.env.inputOfAlice(Utils.fromFixPoint(d, this.width, this.offset));
    }

    @Override
    public T[] inputOfBob(double d) {
        return this.env.inputOfBob(Utils.fromFixPoint(d, this.width, this.offset));
    }

    @Override
    public T[] add(T[] x, T[] y) {
        return this.lib.add(x, y);
    }

    @Override
    public T[] sub(T[] x, T[] y) {
        return this.lib.sub(x, y);
    }

    @Override
    public T[] multiply(T[] x, T[] y) {
        T[] res = this.lib.karatsubaMultiply(this.lib.absolute(x), this.lib.absolute(y));
        res = Arrays.copyOfRange(res, this.offset, this.offset + this.width);
        return this.lib.addSign(res, this.lib.xor(x[x.length - 1], y[y.length - 1]));
    }

    @Override
    public T[] div(T[] x, T[] y) {
        T[] padX = this.lib.padSignedSignal(x, x.length + this.offset);
        return Arrays.copyOf(this.lib.div(this.lib.leftPublicShift(padX, this.offset), y), this.width);
    }

    @Override
    public T[] publicValue(double d) {
        boolean[] a = Utils.fromFixPoint(d, this.width, this.offset);
        T[] res = this.env.newTArray(this.width);
        int i = 0;
        while (i < this.width) {
            res[i] = a[i] ? this.lib.SIGNAL_ONE : this.lib.SIGNAL_ZERO;
            ++i;
        }
        return res;
    }

    @Override
    public T leq(T[] a, T[] b) {
        return this.lib.leq(a, b);
    }

    @Override
    public T eq(T[] a, T[] b) {
        return this.lib.eq(a, b);
    }

    @Override
    public T[] sqrt(T[] a) {
        T[] res = this.lib.sqrt(a);
        return this.lib.leftPublicShift(res, this.offset / 2);
    }

    @Override
    public CompEnv<T> getEnv() {
        return this.env;
    }

    @Override
    public T[] toSecureInt(T[] a, IntegerLib<T> lib) {
        T[] intPart;
        T[] res = lib.env.newTArray(lib.width);
        if (res.length >= (intPart = Arrays.copyOfRange(a, this.offset, a.length)).length) {
            System.arraycopy(intPart, 0, res, 0, intPart.length);
        } else {
            res = Arrays.copyOf(intPart, res.length);
        }
        return res;
    }

    @Override
    public T[] toSecureFloat(T[] a, FloatLib<T> lib) {
        return null;
    }

    @Override
    public T[] toSecureFixPoint(T[] a, FixedPointLib<T> lib) {
        return a;
    }

    @Override
    public double outputToAlice(T[] a) {
        return Utils.toFixPoint(this.env.outputToAlice(a), this.offset);
    }

    @Override
    public int numBits() {
        return this.width;
    }
}

