/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.circuits.arithmetic;

import com.oblivm.backend.circuits.arithmetic.ArithmeticLib;
import com.oblivm.backend.circuits.arithmetic.FixedPointLib;
import com.oblivm.backend.circuits.arithmetic.IntegerLib;
import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.util.Utils;
import java.util.Arrays;

public class FloatLib<T>
implements ArithmeticLib<T> {
    CompEnv<T> env;
    IntegerLib<T> lib;
    public int VLength;
    public int PLength;

    public FloatLib(CompEnv<T> e, int VLength, int PLength) {
        this.env = e;
        this.lib = new IntegerLib<T>(e);
        this.VLength = VLength;
        this.PLength = PLength;
    }

    @Override
    public T[] inputOfAlice(double d) {
        return this.env.inputOfAlice(Utils.fromFloat(d, this.VLength, this.PLength));
    }

    @Override
    public T[] inputOfBob(double d) {
        return this.env.inputOfBob(Utils.fromFloat(d, this.VLength, this.PLength));
    }

    public T[] pack(Representation<T> f) {
        assert (f.v.length == this.VLength && f.p.length == this.PLength) : "pack: not compatiable";
        T[] res = this.env.newTArray(1 + f.v.length + f.p.length);
        res[0] = f.s;
        System.arraycopy(f.v, 0, res, 1, f.v.length);
        System.arraycopy(f.p, 0, res, 1 + f.v.length, f.p.length);
        return res;
    }

    public Representation<T> unpack(T[] data) {
        assert (data.length == this.VLength + this.PLength + 1) : "unpack: not compatiable";
        T[] v = Arrays.copyOfRange(data, 1, 1 + this.VLength);
        T[] p = Arrays.copyOfRange(data, 1 + this.VLength, data.length);
        return new Representation<T>(data[0], v, p);
    }

    @Override
    public T[] multiply(T[] fa, T[] fb) {
        Representation<T> a = this.unpack(fa);
        Representation<T> b = this.unpack(fb);
        Object new_s = this.lib.xor(a.s, b.s);
        T[] a_multi_b = this.lib.karatsubaMultiply(a.v, b.v);
        T[] a_add_b = this.lib.add(a.p, b.p);
        T toShift = this.lib.not(a_multi_b[a_multi_b.length - 1]);
        T[] Shifted = this.lib.conditionalLeftPublicShift(a_multi_b, 1, toShift);
        T[] new_v = Arrays.copyOfRange(Shifted, a.v.length, a.v.length * 2);
        T[] new_p = this.lib.add(a_add_b, this.lib.toSignals(a.v.length, a_add_b.length));
        T[] decrement = this.lib.zeros(new_p.length);
        decrement[0] = toShift;
        new_p = this.lib.sub(new_p, decrement);
        Representation res = new Representation(new_s, new_v, new_p);
        return this.pack(res);
    }

    @Override
    public T[] div(T[] fa, T[] fb) {
        Representation<T> a = this.unpack(fa);
        Representation<T> b = this.unpack(fb);
        Object new_s = this.lib.xor(a.s, b.s);
        int length = a.v.length;
        int newLength = a.v.length * 2;
        T[] padded_av = this.lib.padSignal(a.v, newLength);
        T[] padded_bv = this.lib.padSignal(b.v, b.v.length + 1);
        T[] shifted_av = this.lib.leftPublicShift(padded_av, newLength - length - 1);
        T[] a_div_b = Arrays.copyOf(this.lib.divInternal(shifted_av, padded_bv), shifted_av.length);
        T[] leadingzero = this.lib.leadingZeros(a_div_b);
        T[] sh = this.lib.leftPrivateShift(a_div_b, leadingzero);
        sh = this.lib.rightPublicShift(sh, newLength - length);
        T[] new_v = Arrays.copyOf(sh, length);
        T[] new_p = this.lib.add(this.lib.sub(a.p, b.p), this.lib.toSignals(1L, a.p.length));
        new_p = this.lib.sub(this.lib.padSignal(new_p, leadingzero.length), leadingzero);
        new_p = this.lib.padSignedSignal(new_p, a.p.length);
        Representation res = new Representation(new_s, new_v, new_p);
        return this.pack(res);
    }

    @Override
    public T[] publicValue(double d) {
        boolean[] b = Utils.fromFloat(d, this.VLength, this.PLength);
        T[] res = this.env.newTArray(this.PLength + this.VLength + 1);
        int i = 0;
        while (i < b.length) {
            res[i] = b[i] ? this.lib.SIGNAL_ONE : this.lib.SIGNAL_ZERO;
            ++i;
        }
        return res;
    }

    private T[] addInternal(T sa, T sb, T[] va, T[] vb, T[] p, T[] pDiff) {
        int temp_length = 2 * this.VLength + 1;
        T[] signedVa = this.lib.padSignal(va, temp_length);
        T[] signedVb = this.lib.padSignal(vb, temp_length);
        signedVb = this.lib.leftPrivateShift(signedVb, pDiff);
        signedVa = this.lib.addSign(signedVa, sa);
        signedVb = this.lib.addSign(signedVb, sb);
        T[] new_v = this.lib.add(signedVa, signedVb);
        T new_s = new_v[new_v.length - 1];
        new_v = this.lib.absolute(new_v);
        T[] leadingzero = this.lib.leadingZeros(new_v);
        T[] sh = this.lib.leftPrivateShift(new_v, leadingzero);
        sh = this.lib.rightPublicShift(sh, temp_length - this.VLength);
        new_v = Arrays.copyOf(sh, this.VLength);
        T[] new_p = this.lib.sub(this.lib.padSignal(p, leadingzero.length), leadingzero);
        new_p = this.lib.add(new_p, this.lib.toSignals(temp_length - this.VLength, new_p.length));
        new_p = this.lib.padSignedSignal(new_p, this.PLength);
        Representation<T> res = new Representation<T>(new_s, new_v, new_p);
        return this.pack(res);
    }

    @Override
    public T[] add(T[] fa, T[] fb) {
        T[] va = Arrays.copyOfRange(fa, 1, 1 + this.VLength);
        T[] vb = Arrays.copyOfRange(fb, 1, 1 + this.VLength);
        T[] pa = Arrays.copyOfRange(fa, 1 + this.VLength, fa.length);
        T[] pb = Arrays.copyOfRange(fb, 1 + this.VLength, fb.length);
        T[] pDifference = this.lib.sub(pa, pb);
        T[] pDiffAbs = this.lib.absolute(pDifference);
        T paGreater = this.lib.not(pDifference[pDifference.length - 1]);
        T[] pToUse = this.lib.mux(pa, pb, paGreater);
        T[] normalCase = this.addInternal(this.lib.mux(fa[0], fb[0], paGreater), this.lib.mux(fb[0], fa[0], paGreater), this.lib.mux(va, vb, paGreater), this.lib.mux(vb, va, paGreater), pToUse, pDiffAbs);
        T underFlowHappen = this.lib.not(this.lib.leq(pDiffAbs, this.lib.toSignals(this.VLength, pDiffAbs.length)));
        T[] underFlowResult = this.lib.mux(fb, fa, paGreater);
        return this.lib.mux(normalCase, underFlowResult, underFlowHappen);
    }

    @Override
    public T[] sqrt(T[] fa) {
        int newLength = this.VLength + 2 + 1;
        T[] va = Arrays.copyOfRange(fa, 1, 1 + this.VLength);
        T[] pa = Arrays.copyOfRange(fa, 1 + this.VLength, fa.length);
        va = this.lib.padSignal(va, newLength);
        va = this.lib.leftPublicShift(va, 1);
        pa = this.lib.sub(pa, this.lib.toSignals(1L, this.PLength));
        va = this.lib.conditionalLeftPublicShift(va, 1, pa[0]);
        va = this.lib.sqrt(va);
        pa = this.lib.rightPublicShift(pa, 1);
        pa[pa.length - 1] = pa[pa.length - 2];
        T[] leadingzero = this.lib.leadingZeros(va);
        T[] sh = this.lib.leftPrivateShift(va, leadingzero);
        sh = this.lib.rightPublicShift(sh, newLength - this.VLength);
        T[] new_v = Arrays.copyOf(sh, this.VLength);
        pa = this.lib.sub(pa, this.lib.padSignal(leadingzero, pa.length));
        pa = this.lib.add(pa, this.lib.toSignals(newLength - this.VLength, this.PLength));
        return this.pack(new Representation<Object>(this.lib.SIGNAL_ZERO, new_v, pa));
    }

    @Override
    public T[] sub(T[] a, T[] b) {
        T[] negB = Arrays.copyOf(b, b.length);
        negB[0] = this.lib.not(negB[0]);
        return this.add(a, negB);
    }

    @Override
    public T leq(T[] a, T[] b) {
        T[] res = this.sub(a, b);
        return this.lib.not(res[0]);
    }

    @Override
    public T eq(T[] a, T[] b) {
        return this.lib.eq(a, b);
    }

    @Override
    public CompEnv<T> getEnv() {
        return this.env;
    }

    @Override
    public T[] toSecureInt(T[] a, IntegerLib<T> lib) {
        return null;
    }

    @Override
    public T[] toSecureFloat(T[] a, FloatLib<T> lib) {
        return null;
    }

    @Override
    public T[] toSecureFixPoint(T[] a, FixedPointLib<T> lib) {
        return null;
    }

    @Override
    public double outputToAlice(T[] a) {
        return Utils.toFloat(this.env.outputToAlice(a), this.VLength, this.PLength);
    }

    @Override
    public int numBits() {
        return this.VLength + this.PLength + 1;
    }

    public static class Representation<T> {
        public T s;
        public T[] v;
        public T[] p;

        public Representation(T sign, T[] v, T[] p) {
            this.s = sign;
            this.p = p;
            this.v = v;
        }
    }
}

