/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.oram.Block;
import com.oblivm.backend.oram.BucketLib;
import com.oblivm.backend.oram.PlainBlock;
import com.oblivm.backend.util.Utils;
import java.util.Arrays;

public abstract class OramParty<T> {
    public int N;
    int dataSize;
    public int logN;
    public int lengthOfIden;
    public int lengthOfPos;
    public int lengthOfData;
    public CompEnv<T> env;
    public Party p;
    public Mode mode;
    public BucketLib<T> lib;
    boolean[] dummyArray;
    PlainBlock pb_for_count_mode;
    PlainBlock r = this.getDummyBlock(true);

    void setParameters(CompEnv<T> env, int N, int dataSize) {
        this.env = env;
        this.dataSize = dataSize;
        long a = 1L;
        this.logN = 1;
        while (a < (long)N) {
            a *= 2L;
            ++this.logN;
        }
        --this.logN;
        this.N = 1 << this.logN;
        this.lengthOfData = dataSize;
        this.lengthOfIden = this.logN;
    }

    public OramParty(CompEnv<T> env, int N, int dataSize) {
        this.setParameters(env, N, dataSize);
        this.lengthOfPos = this.logN - 1;
        this.p = env.party;
        this.mode = env.mode;
        this.init();
    }

    public OramParty(CompEnv<T> env, int N, int dataSize, int lengthOfPos) {
        this.setParameters(env, N, dataSize);
        this.lengthOfPos = lengthOfPos;
        this.p = env.party;
        this.mode = env.mode;
        this.init();
    }

    public void init() {
        this.dummyArray = new boolean[this.lengthOfIden + this.lengthOfPos + this.lengthOfData + 1];
        int i = 0;
        while (i < this.dummyArray.length) {
            this.dummyArray[i] = false;
            ++i;
        }
        this.lib = new BucketLib<T>(this.lengthOfIden, this.lengthOfPos, this.lengthOfData, this.env);
        boolean[] data = new boolean[this.lengthOfData];
        int i2 = 0;
        while (i2 < this.lengthOfData) {
            data[i2] = true;
            ++i2;
        }
        this.pb_for_count_mode = new PlainBlock(0L, 0L, data, false);
    }

    public Block<T>[] prepareBlocks(PlainBlock[] clientBlock, PlainBlock[] serverBlock) {
        Block<T>[] s = this.inputBucketOfServer(serverBlock);
        Block<T>[] c = this.inputBucketOfClient(clientBlock);
        return this.lib.xor(s, c);
    }

    public Block<T> prepareBlock(PlainBlock clientBlock, PlainBlock serverBlock) {
        Block<T> s = this.inputBlockOfServer(serverBlock);
        Block<T> c = this.inputBlockOfClient(clientBlock);
        return this.lib.xor(s, c);
    }

    public PlainBlock preparePlainBlock(Block<T> blocks, Block<T> randomBlock) {
        PlainBlock result = this.outputBlock(this.lib.xor(blocks, randomBlock));
        return result;
    }

    public PlainBlock[] preparePlainBlocks(Block<T>[] blocks, Block<T>[] randomBlock) {
        PlainBlock[] result = this.outputBucket(this.lib.xor(blocks, randomBlock));
        return result;
    }

    public Block<T> inputBlockOfServer(PlainBlock b) {
        T[] TArray = this.env.inputOfBob(b.toBooleanArray(this.lengthOfIden, this.lengthOfPos));
        return new Block<T>(TArray, this.lengthOfIden, this.lengthOfPos, this.lengthOfData);
    }

    public Block<T> inputBlockOfClient(PlainBlock b) {
        T[] TArray = this.env.inputOfAlice(b.toBooleanArray(this.lengthOfIden, this.lengthOfPos));
        return new Block<T>(TArray, this.lengthOfIden, this.lengthOfPos, this.lengthOfData);
    }

    public Block<T>[] toBlocks(T[] Tarray, int lengthOfIden, int lengthOfPos, int lengthOfData, int capacity) {
        int blockSize = lengthOfIden + lengthOfPos + lengthOfData + 1;
        Block<T>[] result = this.lib.newBlockArray(capacity);
        int i = 0;
        while (i < capacity) {
            result[i] = new Block<T>(Arrays.copyOfRange(Tarray, i * blockSize, (i + 1) * blockSize), lengthOfIden, lengthOfPos, lengthOfData);
            ++i;
        }
        return result;
    }

    public Block<T>[] inputBucketOfServer(PlainBlock[] b) {
        T[] TArray = this.env.inputOfBob(PlainBlock.toBooleanArray(b, this.lengthOfIden, this.lengthOfPos));
        return this.toBlocks(TArray, this.lengthOfIden, this.lengthOfPos, this.lengthOfData, b.length);
    }

    public Block<T>[] inputBucketOfClient(PlainBlock[] b) {
        T[] TArray = this.env.inputOfAlice(PlainBlock.toBooleanArray(b, this.lengthOfIden, this.lengthOfPos));
        this.env.flush();
        return this.toBlocks(TArray, this.lengthOfIden, this.lengthOfPos, this.lengthOfData, b.length);
    }

    public PlainBlock outputBlock(Block<T> b) {
        boolean[] iden = this.env.outputToAlice(b.iden);
        boolean[] pos = this.env.outputToAlice(b.pos);
        boolean[] data = this.env.outputToAlice(b.data);
        boolean isDummy = this.env.outputToAlice(b.isDummy);
        return new PlainBlock(Utils.toLong(iden), Utils.toLong(pos), data, isDummy);
    }

    public PlainBlock[] outputBucket(Block<T>[] b) {
        PlainBlock[] result = new PlainBlock[b.length];
        int i = 0;
        while (i < b.length) {
            result[i] = this.outputBlock(b[i]);
            ++i;
        }
        return result;
    }

    public PlainBlock[][] outputBuckets(Block<T>[][] b) {
        PlainBlock[][] result = new PlainBlock[b.length][];
        int i = 0;
        while (i < b.length) {
            result[i] = this.outputBucket(b[i]);
            ++i;
        }
        this.env.flush();
        return result;
    }

    public PlainBlock getDummyBlock(boolean b) {
        if (this.mode == Mode.COUNT) {
            return this.pb_for_count_mode;
        }
        boolean[] data = new boolean[this.lengthOfData];
        int i = 0;
        while (i < this.lengthOfData) {
            data[i] = true;
            ++i;
        }
        return new PlainBlock(0L, 0L, data, b);
    }

    public PlainBlock randomBlock() {
        if (this.mode == Mode.COUNT) {
            return this.pb_for_count_mode;
        }
        boolean[] data = new boolean[this.lengthOfData];
        int i = 0;
        while (i < this.lengthOfData) {
            data[i] = CompEnv.rnd.nextBoolean();
            ++i;
        }
        boolean isDummy = CompEnv.rnd.nextBoolean();
        return new PlainBlock(CompEnv.rnd.nextLong(), CompEnv.rnd.nextLong(), data, isDummy);
    }

    public PlainBlock[] randomBucket(int length) {
        PlainBlock[] result = new PlainBlock[length];
        int i = 0;
        while (i < length) {
            result[i] = this.randomBlock();
            ++i;
        }
        return result;
    }
}

