/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.ot;

import com.oblivm.backend.gc.GCSignal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public final class Cipher {
    private static final int unitLength = 160;
    private static final int bytesPerUnit = 20;
    private MessageDigest sha1;
    BigInteger a = BigInteger.ONE;

    public Cipher() {
        try {
            this.sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public BigInteger encrypt(byte[] key, BigInteger msg, int msgLength) {
        assert (msgLength <= 160) : "Message longer than hash block width.";
        return msg.xor(this.getPaddingOfLength(key, msgLength));
    }

    public BigInteger decrypt(byte[] key, BigInteger cph, int cphLength) {
        assert (cphLength > 160) : "Ciphertext longer than hash block width.";
        return cph.xor(this.getPaddingOfLength(key, cphLength));
    }

    private BigInteger getPaddingOfLength(byte[] key, int padLength) {
        byte[] pad = new byte[(padLength - 1) / 8 + 1];
        int i = 0;
        while (i < (pad.length - 1) / 20) {
            assert (i < 128) : "Padding is unexpectedly long.";
            this.sha1.update(key);
            this.sha1.update((byte)i);
            byte[] tmp = this.sha1.digest();
            System.arraycopy(tmp, 0, pad, i * 20, 20);
            ++i;
        }
        return new BigInteger(1, pad);
    }

    public BigInteger encrypt(int j, byte[] key, BigInteger msg, int msgLength) {
        return msg.xor(this.getPaddingOfLength(j, key, msgLength));
    }

    public BigInteger decrypt(int j, byte[] key, BigInteger cph, int cphLength) {
        return cph.xor(this.getPaddingOfLength(j, key, cphLength));
    }

    private BigInteger getPaddingOfLength(int j, byte[] key, int padLength) {
        this.sha1.update(ByteBuffer.allocate(4).putInt(j).array());
        this.sha1.update(key);
        byte[] pad = new byte[(padLength - 1) / 8 + 1];
        byte[] tmp = this.sha1.digest();
        int i = 0;
        while (i < (pad.length - 1) / 20) {
            System.arraycopy(tmp, 0, pad, i * 20, 20);
            this.sha1.update(tmp);
            tmp = this.sha1.digest();
            ++i;
        }
        System.arraycopy(tmp, 0, pad, i * 20, pad.length - i * 20);
        return new BigInteger(1, pad);
    }

    public GCSignal enc(GCSignal key, GCSignal m, int k) {
        return this.getPadding(key, k).xor(m);
    }

    public GCSignal dec(GCSignal key, GCSignal c, int k) {
        return this.getPadding(key, k).xor(c);
    }

    private GCSignal getPadding(GCSignal key, int k) {
        this.sha1.update(key.bytes);
        this.sha1.update(ByteBuffer.allocate(4).putInt(k).array());
        GCSignal ret = GCSignal.newInstance(this.sha1.digest());
        return ret;
    }
}

