/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.rand;

import com.oblivm.backend.rand.ISAACAlgorithm;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class ISAACEngine
extends SecureRandomSpi {
    private static final long serialVersionUID = 1L;
    private ISAACAlgorithm isaac;
    private byte[] remainder;
    private int remCount = 0;
    private static final int[] mask = new int[]{-16777216, 0xFF0000, 65280, 255};

    public ISAACEngine() {
        byte[] temp = new byte[1024];
        new SecureRandom().nextBytes(temp);
        this.isaac = new ISAACAlgorithm(ISAACEngine.packToIntArray(temp));
    }

    @Override
    public byte[] engineGenerateSeed(int numBytes) {
        byte[] seed = new byte[numBytes];
        this.engineNextBytes(seed);
        return seed;
    }

    @Override
    public void engineNextBytes(byte[] bytes) {
        int i;
        int todo;
        int index = 0;
        byte[] output = this.remainder;
        int rC = this.remCount;
        if (rC > 0) {
            todo = bytes.length - index < 4 - rC ? bytes.length - index : 4 - rC;
            i = 0;
            while (i < todo) {
                bytes[i] = output[rC];
                ++i;
                ++rC;
            }
            this.remCount += todo;
            index += todo;
        }
        while (index < bytes.length) {
            output = ISAACEngine.toByteArray(this.isaac.nextInt());
            todo = bytes.length - index > 4 ? 4 : bytes.length - index;
            i = 0;
            while (i < todo) {
                bytes[index] = output[i];
                ++i;
                ++index;
            }
            this.remCount += todo;
        }
        this.remainder = output;
        this.remCount %= 4;
    }

    @Override
    public void engineSetSeed(byte[] seed) {
        this.isaac.supplementSeed(ISAACEngine.packToIntArray(seed));
    }

    private static byte[] toByteArray(int intValue) {
        int byteNum = (40 - ISAACEngine.numberOfLeadingZeros(intValue < 0 ? ~intValue : intValue)) / 8;
        byte[] byteArray = new byte[4];
        int i = 0;
        while (i < byteNum) {
            byteArray[3 - i] = (byte)(intValue >>> i * 8);
            ++i;
        }
        return byteArray;
    }

    private static int numberOfLeadingZeros(int intValue) {
        if (intValue == 0) {
            return 32;
        }
        int num = 1;
        int i = 16;
        int j = 16;
        while (j > 1) {
            if (intValue >>> i == 0) {
                num += j;
                intValue <<= j;
            }
            i += (j /= 2);
        }
        return num -= intValue >>> 31;
    }

    private static int[] packToIntArray(byte[] ba) {
        if (ba == null) {
            return new int[0];
        }
        int[] ia = new int[(ba.length + 3) / 4];
        int i = 0;
        while (i < ia.length) {
            int restLen = Math.min(4, ba.length - i * 4);
            int b = 0;
            while (b < restLen) {
                int n = i;
                ia[n] = ia[n] | ba[b + i * 4] << (restLen - b - 1) * 8 & mask[b + 4 - restLen];
                ++b;
            }
            ++i;
        }
        return ia;
    }
}

