/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.util;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Party;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class Utils {
    static final int[] mask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    public static double[] RAND;
    public static int RAND_CNT;
    public static int RAND_LIM;

    static {
        RAND_CNT = 0;
        RAND_LIM = 10000000;
    }

    public static int logFloor(int n) {
        int w = 0;
        --n;
        while (n > 0) {
            ++w;
            n >>= 1;
        }
        return w == 0 ? 1 : w;
    }

    public static <T> void print(CompEnv<T> env, String name, T[] data, T[] data2, T con) throws Exception {
        int a = Utils.toInt(env.outputToAlice(data));
        int ab = Utils.toInt(env.outputToAlice(data2));
        boolean cc = env.outputToAlice(con);
        if (cc && env.getParty() == Party.Alice && a != 0) {
            System.out.println(String.valueOf(name) + " " + a + " " + ab);
        }
    }

    public static <T> void print(CompEnv<T> env, String name, T[] data) throws Exception {
        long a = Utils.toSignedInt(env.outputToAlice(data));
        if (env.getParty() == Party.Alice && a != 0L) {
            System.out.println(String.valueOf(name) + " " + a);
        }
    }

    public static <T> void print(CompEnv<T> env, String name, T data) throws Exception {
        boolean a = env.outputToAlice(data);
        if (env.getParty() == Party.Alice) {
            System.out.println(String.valueOf(name) + " " + a);
        }
    }

    public static Boolean[] toBooleanArray(boolean[] a) {
        Boolean[] res = new Boolean[a.length];
        int i = 0;
        while (i < a.length) {
            res[i] = a[i];
            ++i;
        }
        return res;
    }

    public static boolean[] tobooleanArray(Boolean[] a) {
        boolean[] res = new boolean[a.length];
        int i = 0;
        while (i < a.length) {
            res[i] = a[i];
            ++i;
        }
        return res;
    }

    public static boolean[] fromInt(int value, int width) {
        boolean[] res = new boolean[width];
        int i = 0;
        while (i < width) {
            res[i] = (value >> i & 1) != 0;
            ++i;
        }
        return res;
    }

    public static int toInt(boolean[] value) {
        int res = 0;
        int i = 0;
        while (i < value.length) {
            res = value[i] ? res | 1 << i : res;
            ++i;
        }
        return res;
    }

    public static long toUnSignedInt(boolean[] v) {
        long result = 0L;
        int i = 0;
        while (i < v.length) {
            if (v[i]) {
                result += 1L << i;
            }
            ++i;
        }
        return result;
    }

    public static long toSignedInt(boolean[] v) {
        int i = 0;
        if (!v[v.length - 1]) {
            return Utils.toUnSignedInt(v);
        }
        boolean[] c2 = new boolean[v.length];
        while (!v[i]) {
            c2[i] = v[i];
            ++i;
        }
        c2[i] = v[i];
        ++i;
        while (i < v.length) {
            c2[i] = !v[i];
            ++i;
        }
        return Utils.toUnSignedInt(c2) * -1L;
    }

    public static boolean[] fromLong(long value, int width) {
        boolean[] res = new boolean[width];
        int i = 0;
        while (i < width) {
            res[i] = (value >> i & 1L) != 0L;
            ++i;
        }
        return res;
    }

    public static long toLong(boolean[] value) {
        long res = 0L;
        int i = 0;
        while (i < value.length) {
            res = value[i] ? res | 1L << i : res;
            ++i;
        }
        return res;
    }

    public static double toFloat(boolean[] value, int widthV, int widthP) {
        boolean[] v = Arrays.copyOfRange(value, 1, 1 + widthV);
        boolean[] p = Arrays.copyOfRange(value, 1 + widthV, value.length);
        double result = value[0] ? -1 : 1;
        long value_v = Utils.toUnSignedInt(v);
        long value_p = Utils.toSignedInt(p);
        result *= (double)value_v;
        BigDecimal b = new BigDecimal(result *= Math.pow(2.0, value_p));
        return b.setScale(6, 4).doubleValue();
    }

    public static boolean[] fromFloat(double d, int widthV, int widthP) {
        boolean s;
        boolean[] v = new boolean[widthV];
        boolean[] p = new boolean[widthP];
        boolean bl = s = d < 0.0;
        if (d == 0.0) {
            int i = 0;
            while (i < widthV) {
                v[i] = false;
                ++i;
            }
            i = 0;
            while (i < widthP) {
                p[i] = false;
                ++i;
            }
            p[widthP - 1] = true;
        } else {
            d = s ? -1.0 * d : d;
            int pInt = 0;
            double lower_bound = Math.pow(2.0, widthV - 1);
            double upper_bound = Math.pow(2.0, widthV);
            while (d < lower_bound) {
                d *= 2.0;
                --pInt;
            }
            while (d >= upper_bound) {
                d /= 2.0;
                ++pInt;
            }
            p = Utils.fromInt(pInt, widthP);
            long tmp = (long)(d + 1.0E-6);
            v = Utils.fromLong(tmp, widthV);
        }
        boolean[] result = new boolean[1 + widthV + widthP];
        result[0] = s;
        System.arraycopy(v, 0, result, 1, v.length);
        System.arraycopy(p, 0, result, 1 + v.length, p.length);
        return result;
    }

    public static boolean[] fromBigInteger(BigInteger bd, int length) {
        byte[] b = bd.toByteArray();
        boolean[] result = new boolean[length];
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < 8 && i * 8 + j < length) {
                result[i * 8 + j] = (b[b.length - i - 1] & mask[j]) >> j == 1;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static BigInteger toBigInteger(boolean[] b) {
        BigInteger res = new BigInteger("0");
        BigInteger c = new BigInteger("1");
        int i = 0;
        while (i < b.length) {
            if (b[i]) {
                res = res.add(c);
            }
            c = c.multiply(new BigInteger("2"));
            ++i;
        }
        return res;
    }

    public static boolean[] fromFixPoint(double a, int width, int offset) {
        return Utils.fromLong((long)(a *= Math.pow(2.0, offset)), width);
    }

    public static double toFixPoint(boolean[] b, int offset) {
        double a = Utils.toSignedInt(b);
        return a /= Math.pow(2.0, offset);
    }

    public static boolean[] flatten(boolean[][] data) {
        int length = 0;
        int i = 0;
        while (i < data.length) {
            length += data[i].length;
            ++i;
        }
        boolean[] ret = new boolean[length];
        int pos = 0;
        int i2 = 0;
        while (i2 < data.length) {
            System.arraycopy(data[i2], 0, ret, pos, data[i2].length);
            pos += data[i2].length;
            ++i2;
        }
        return ret;
    }

    public static boolean[] flatten(boolean[][][] data) {
        int length = 0;
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[0].length) {
                length += data[i][j].length;
                ++j;
            }
            ++i;
        }
        boolean[] ret = new boolean[length];
        int pos = 0;
        int i2 = 0;
        while (i2 < data.length) {
            int j = 0;
            while (j < data[0].length) {
                System.arraycopy(data[i2][j], 0, ret, pos, data[i2][j].length);
                pos += data[i2][j].length;
                ++j;
            }
            ++i2;
        }
        return ret;
    }

    public static <T> T[] flatten(CompEnv<T> env, T[] ... data) {
        int length = 0;
        int i = 0;
        while (i < data.length) {
            length += data[i].length;
            ++i;
        }
        T[] ret = env.newTArray(length);
        int pos = 0;
        int i2 = 0;
        while (i2 < data.length) {
            System.arraycopy(data[i2], 0, ret, pos, data[i2].length);
            pos += data[i2].length;
            ++i2;
        }
        return ret;
    }

    public static <T> T[][] flatten(CompEnv<T> env, T[][] ... data) {
        int length = 0;
        int i = 0;
        while (i < data.length) {
            length += data[i][0].length;
            ++i;
        }
        T[][] ret = env.newTArray(data[0].length, length);
        int pos = 0;
        int i2 = 0;
        while (i2 < data.length) {
            int j = 0;
            while (j < data[0].length) {
                System.arraycopy(data[i2][j], 0, ret[j], pos, data[i2][j].length);
                ++j;
            }
            pos += data[i2][0].length;
            ++i2;
        }
        return ret;
    }

    public static <T> void unflatten(T[][] flat, T[][] ... x) {
        int pos = 0;
        int i = 0;
        while (i < x.length) {
            int j = 0;
            while (j < x[i].length) {
                System.arraycopy(flat[j], pos, x[i][j], 0, x[i][j].length);
                ++j;
            }
            pos += x[i][0].length;
            ++i;
        }
    }

    public static <T> void unflatten(T[] flat, T[] ... x) {
        int pos = 0;
        int i = 0;
        while (i < x.length) {
            System.arraycopy(flat, pos, x[i], 0, x[i].length);
            pos += x[i].length;
            ++i;
        }
    }

    public static <T> void unflatten(T[] flat, T[][][] x) {
        int pos = 0;
        int i = 0;
        while (i < x.length) {
            int j = 0;
            while (j < x[0].length) {
                System.arraycopy(flat, pos, x[i][j], 0, x[i][j].length);
                pos += x[i][j].length;
                ++j;
            }
            ++i;
        }
    }

    private static double getMega(double bytes) {
        return bytes / 1048576.0;
    }

    public static int log2(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    public static double getRandom() {
        double ret = RAND[RAND_CNT];
        RAND_CNT = (RAND_CNT + 1) % RAND_LIM;
        return ret;
    }

    public static void generateRandomNumbers() throws FileNotFoundException, IOException {
        RAND = new double[RAND_LIM];
        BufferedReader reader = new BufferedReader(new FileReader("in/rand.out"));
        int i = 0;
        while (i < RAND_LIM) {
            Utils.RAND[i] = Double.parseDouble(reader.readLine());
            ++i;
        }
        reader.close();
    }
}

