/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.gc;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Flag;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.gc.GCCompEnv;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.gc.offline.GCGen;
import com.oblivm.backend.network.Network;
import com.oblivm.backend.ot.FakeOTSender;
import com.oblivm.backend.ot.OTExtSender;
import com.oblivm.backend.ot.OTPreprocessSender;
import com.oblivm.backend.ot.OTSender;
import java.io.IOException;

public abstract class GCGenComp
extends GCCompEnv {
    public static GCSignal R = null;
    OTSender snd;
    protected long gid = 0L;
    protected boolean gatesRemain = false;

    static {
        R = GCSignal.freshLabel(CompEnv.rnd);
        R.setLSB();
    }

    public GCGenComp(Network channel, Mode mode) {
        super(channel, Party.Alice, mode);
        this.snd = Flag.FakeOT ? new FakeOTSender(80, channel) : (Flag.ProprocessOT ? new OTPreprocessSender(80, channel) : new OTExtSender(80, channel));
    }

    public static GCSignal[] genPairForLabel(Mode mode) {
        GCSignal[] label = new GCSignal[2];
        if (mode != Mode.OFFLINE || !Flag.offline) {
            label[0] = GCSignal.freshLabel(rnd);
        }
        if (mode == Mode.OFFLINE) {
            if (Flag.offline) {
                label[0] = new GCSignal(GCGen.fread.read(10));
            } else {
                label[0].send(GCGen.fout);
            }
        }
        label[1] = R.xor(label[0]);
        return label;
    }

    public static GCSignal[] genPair() {
        GCSignal[] label;
        label = new GCSignal[]{GCSignal.freshLabel(rnd), R.xor(label[0])};
        return label;
    }

    @Override
    public GCSignal inputOfAlice(boolean in) {
        Flag.sw.startOT();
        GCSignal[] label = GCGenComp.genPairForLabel(this.mode);
        Flag.sw.startOTIO();
        label[in ? 1 : 0].send(this.channel);
        this.flush();
        Flag.sw.stopOTIO();
        Flag.sw.stopOT();
        return label[0];
    }

    @Override
    public GCSignal inputOfBob(boolean in) {
        Flag.sw.startOT();
        GCSignal[] label = GCGenComp.genPairForLabel(this.mode);
        try {
            this.snd.send(label);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Flag.sw.stopOT();
        return label[0];
    }

    public GCSignal[] inputOfAlice(boolean[] x) {
        Flag.sw.startOT();
        GCSignal[][] pairs = new GCSignal[x.length][2];
        GCSignal[] result = new GCSignal[x.length];
        int i = 0;
        while (i < x.length) {
            pairs[i] = GCGenComp.genPairForLabel(this.mode);
            result[i] = pairs[i][0];
            ++i;
        }
        Flag.sw.startOTIO();
        i = 0;
        while (i < x.length) {
            pairs[i][x[i] ? 1 : 0].send(this.channel);
            ++i;
        }
        this.flush();
        Flag.sw.stopOTIO();
        Flag.sw.stopOT();
        return result;
    }

    public GCSignal[] inputOfBob(boolean[] x) {
        Flag.sw.startOT();
        GCSignal[][] pair = new GCSignal[x.length][2];
        int i = 0;
        while (i < x.length) {
            pair[i] = GCGenComp.genPairForLabel(this.mode);
            ++i;
        }
        try {
            this.snd.send(pair);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GCSignal[] result = new GCSignal[x.length];
        int i2 = 0;
        while (i2 < x.length) {
            result[i2] = pair[i2][0];
            ++i2;
        }
        Flag.sw.stopOT();
        return result;
    }

    @Override
    public boolean outputToAlice(GCSignal out) {
        if (this.gatesRemain) {
            this.gatesRemain = false;
            this.flush();
        }
        if (out.isPublic()) {
            return out.v;
        }
        GCSignal lb = GCSignal.receive(this.channel);
        if (lb.equals(out)) {
            return false;
        }
        if (lb.equals(R.xor(out))) {
            return true;
        }
        try {
            throw new Exception("bad label at final output.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean outputToBob(GCSignal out) {
        if (!out.isPublic()) {
            out.send(this.channel);
        }
        return false;
    }

    public boolean[] outputToBob(GCSignal[] out) {
        boolean[] result = new boolean[out.length];
        int i = 0;
        while (i < result.length) {
            if (!out[i].isPublic()) {
                out[i].send(this.channel);
            }
            ++i;
        }
        this.flush();
        i = 0;
        while (i < result.length) {
            result[i] = false;
            ++i;
        }
        return result;
    }

    public boolean[] outputToAlice(GCSignal[] out) {
        boolean[] result = new boolean[out.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.outputToAlice(out[i]);
            ++i;
        }
        return result;
    }

    @Override
    public GCSignal xor(GCSignal a, GCSignal b) {
        if (a.isPublic() && b.isPublic()) {
            return new GCSignal(a.v ^ b.v);
        }
        if (a.isPublic()) {
            return a.v ? this.not(b) : new GCSignal(b);
        }
        if (b.isPublic()) {
            return b.v ? this.not(a) : new GCSignal(a);
        }
        return a.xor(b);
    }

    @Override
    public GCSignal not(GCSignal a) {
        if (a.isPublic()) {
            return new GCSignal(!a.v);
        }
        return R.xor(a);
    }
}

