/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.network;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Mode;
import com.oblivm.backend.gc.GCSignal;
import com.oblivm.backend.network.CustomizedConcurrentQueue;
import com.oblivm.backend.network.ThreadedIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;

public class Network {
    protected Socket sock;
    protected ServerSocket serverSock;
    public CustomizedConcurrentQueue queue;
    ThreadedIO threadedio;
    public InputStream is;
    protected OutputStream os;
    Thread thd;
    boolean THREADEDIO = false;
    static int NetworkThreadedQueueSize = 262144;

    public void setUpThread() {
        if (this.THREADEDIO) {
            this.queue = new CustomizedConcurrentQueue(NetworkThreadedQueueSize);
            this.threadedio = new ThreadedIO(this.queue, this.os);
            this.thd = new Thread(this.threadedio);
            this.thd.start();
        }
    }

    public Network() {
    }

    public Network(InputStream is, OutputStream os, Socket sock) {
        this.is = is;
        this.os = os;
        this.sock = sock;
    }

    public void disconnect() {
        try {
            if (this.THREADEDIO) {
                this.queue.destory();
                this.os.flush();
                this.thd.join();
            }
            this.os.flush();
            if (this.sock != null) {
                this.sock.close();
            }
            if (this.serverSock != null) {
                this.serverSock.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] readBytes(int len) {
        byte[] temp = new byte[len];
        try {
            int remain = len;
            while (remain > 0) {
                int readBytes = this.is.read(temp, len - remain, remain);
                if (readBytes == -1) continue;
                remain -= readBytes;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return temp;
    }

    public void readBytes(byte[] temp) {
        try {
            int remain = temp.length;
            while (remain > 0) {
                int readBytes = this.is.read(temp, temp.length - remain, remain);
                if (readBytes == -1) continue;
                remain -= readBytes;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] readBytes() {
        byte[] lenBytes = this.readBytes(4);
        int len = ByteBuffer.wrap(lenBytes).getInt();
        return this.readBytes(len);
    }

    public void writeByte(byte[] data) {
        this.writeByte(ByteBuffer.allocate(4).putInt(data.length).array(), 4);
        this.writeByte(data, data.length);
    }

    public void writeByte(byte[] data, int length) {
        try {
            if (this.THREADEDIO) {
                this.queue.insert(data);
            } else {
                this.os.write(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void writeByte(byte data) {
        try {
            if (this.THREADEDIO) {
                this.queue.insert(new byte[]{data});
            } else {
                this.os.write(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeBI(BigInteger bi) {
        this.writeByte(bi.toByteArray());
    }

    public BigInteger readBI() {
        byte[] rep = this.readBytes();
        return new BigInteger(rep);
    }

    public void writeInt(int i) {
        this.writeByte(ByteBuffer.allocate(4).putInt(i).array(), 4);
    }

    public int readInt() {
        return ByteBuffer.wrap(this.readBytes(4)).getInt();
    }

    public <T> void send(T[][][] data, CompEnv<T> env) throws IOException {
        int i = 0;
        while (i < data.length) {
            this.send((T)data[i], env);
            ++i;
        }
    }

    public <T> void send(T[][] data, CompEnv<T> env) throws IOException {
        int i = 0;
        while (i < data.length) {
            this.send((T)data[i], env);
            ++i;
        }
    }

    public <T> T[][] read(int length1, int length2, CompEnv<T> env) throws IOException {
        T[][] ret = env.newTArray(length1, 1);
        int i = 0;
        while (i < length1) {
            ret[i] = this.read(length2, env);
            ++i;
        }
        return ret;
    }

    public <T> T[][][] read(int length1, int length2, int length3, CompEnv<T> env) throws IOException {
        T[][][] ret = env.newTArray(length1, 1, 1);
        int i = 0;
        while (i < length1) {
            ret[i] = this.read(length2, length3, env);
            ++i;
        }
        return ret;
    }

    public <T> void send(T[] data, CompEnv<T> env) throws IOException {
        int i = 0;
        while (i < data.length) {
            this.send(data[i], env);
            ++i;
        }
    }

    public <T> void send(T data, CompEnv<T> env) throws IOException {
        block1: {
            Mode mode;
            block0: {
                mode = env.getMode();
                if (mode != Mode.REAL) break block0;
                GCSignal gcData = (GCSignal)data;
                gcData.send(this);
                break block1;
            }
            if (mode != Mode.VERIFY) break block1;
            this.writeBoolean((Boolean)data);
        }
    }

    public <T> T[] read(int length, CompEnv<T> env) throws IOException {
        T[] ret = env.newTArray(length);
        int i = 0;
        while (i < length) {
            ret[i] = this.read(env);
            ++i;
        }
        return ret;
    }

    public <T> T read(CompEnv<T> env) throws IOException {
        Mode mode = env.getMode();
        if (mode == Mode.REAL || mode == Mode.OPT || mode == Mode.OFFLINE) {
            GCSignal signal = GCSignal.receive(this);
            return (T)signal;
        }
        if (mode == Mode.VERIFY) {
            Boolean vData = this.readBoolean();
            return (T)vData;
        }
        if (mode == Mode.COUNT) {
            return env.ZERO();
        }
        return null;
    }

    public boolean readBoolean() throws IOException {
        int read = this.readInt();
        return read == 1;
    }

    public void writeBoolean(boolean data) throws IOException {
        int sen = data ? 1 : 0;
        this.writeInt(sen);
    }
}

