/*
 * Decompiled with CFR 0.152.
 */
package com.oblivm.backend.oram;

import com.oblivm.backend.flexsc.CompEnv;
import com.oblivm.backend.flexsc.Party;
import com.oblivm.backend.oram.CircuitOram;
import com.oblivm.backend.oram.LinearScanOram;
import com.oblivm.backend.oram.OramParty;
import java.util.ArrayList;
import java.util.Arrays;

public class RecursiveCircuitOram<T> {
    public LinearScanOram<T> baseOram;
    public ArrayList<CircuitOram<T>> clients = new ArrayList();
    public int lengthOfIden;
    int recurFactor;
    int cutoff;
    int capacity;
    Party p;

    public RecursiveCircuitOram(CompEnv<T> env, int N, int dataSize, int cutoff, int recurFactor, int capacity, int sp) {
        this.init(env, N, dataSize, cutoff, recurFactor, capacity, sp);
    }

    public RecursiveCircuitOram(CompEnv<T> env, int N, int dataSize, int cutoff, int recurFactor) {
        this.init(env, N, dataSize, cutoff, recurFactor, 3, 80);
    }

    public RecursiveCircuitOram(CompEnv<T> env, int N, int dataSize) {
        this.init(env, N, dataSize, 64, 8, 3, 80);
    }

    public void setInitialValue(int initial) {
        this.clients.get(0).setInitialValue(initial);
    }

    void init(CompEnv<T> env, int N, int dataSize, int cutoff, int recurFactor, int capacity, int sp) {
        this.p = env.party;
        this.cutoff = cutoff;
        this.recurFactor = recurFactor;
        this.capacity = capacity;
        CircuitOram<T> oram = new CircuitOram<T>(env, N, dataSize, capacity, sp);
        this.lengthOfIden = oram.lengthOfIden;
        this.clients.add(oram);
        int newDataSize = oram.lengthOfPos * recurFactor;
        int newN = (1 << oram.lengthOfIden) / recurFactor;
        while (newN > cutoff) {
            oram = new CircuitOram<T>(env, newN, newDataSize, capacity, sp);
            this.clients.add(oram);
            newDataSize = oram.lengthOfPos * recurFactor;
            newN = (1 << oram.lengthOfIden) / recurFactor;
        }
        CircuitOram<T> last = this.clients.get(this.clients.size() - 1);
        this.baseOram = new LinearScanOram<T>(env, 1 << last.lengthOfIden, last.lengthOfPos);
    }

    public T[] read(T[] iden) {
        T[][] poses = this.travelToDeep(iden, 1);
        CircuitOram<T> currentOram = this.clients.get(0);
        boolean[] oldPos = this.baseOram.lib.declassifyToBoth(poses[0]);
        T[] res = currentOram.read(iden, oldPos, poses[1]);
        return res;
    }

    public void write(T[] iden, T[] data) {
        T[][] poses = this.travelToDeep(iden, 1);
        CircuitOram<T> currentOram = this.clients.get(0);
        boolean[] oldPos = this.baseOram.lib.declassifyToBoth(poses[0]);
        currentOram.write(iden, oldPos, poses[1], data);
    }

    public void write(T[] iden, T[] data, T dummy) {
        T[][] poses = this.travelToDeep(iden, 1);
        CircuitOram<T> currentOram = this.clients.get(0);
        currentOram.write(iden, poses[0], poses[1], data, dummy);
    }

    public T[] access(T[] iden, T[] data, T op) {
        T[][] poses = this.travelToDeep(iden, 1);
        CircuitOram<T> currentOram = this.clients.get(0);
        boolean[] oldPos = this.baseOram.lib.declassifyToBoth(poses[0]);
        return currentOram.access(iden, oldPos, poses[1], data, op);
    }

    public T[][] travelToDeep(T[] iden, int level) {
        if (level == this.clients.size()) {
            T[] baseMap = this.baseOram.readAndRemove(this.baseOram.lib.padSignal(iden, this.baseOram.lengthOfIden));
            T[] ithPos = this.baseOram.lib.rightPublicShift(iden, this.baseOram.lengthOfIden);
            T[] pos = this.extract(baseMap, ithPos, this.clients.get((int)(level - 1)).lengthOfPos);
            T[] newPos = this.baseOram.lib.randBools(this.clients.get((int)(level - 1)).lengthOfPos);
            this.put(baseMap, ithPos, newPos);
            this.baseOram.putBack(this.baseOram.lib.padSignal(iden, this.baseOram.lengthOfIden), baseMap);
            T[][] result = this.baseOram.env.newTArray(2, 0);
            result[0] = pos;
            result[1] = newPos;
            return result;
        }
        CircuitOram<T> currentOram = this.clients.get(level);
        T[][] poses = this.travelToDeep(this.subIdentifier(iden, currentOram), level + 1);
        boolean[] oldPos = this.baseOram.lib.declassifyToBoth(poses[0]);
        T[] data = currentOram.readAndRemove(this.subIdentifier(iden, currentOram), oldPos, true);
        T[] ithPos = currentOram.lib.rightPublicShift(iden, currentOram.lengthOfIden);
        T[] pos = this.extract(data, ithPos, this.clients.get((int)(level - 1)).lengthOfPos);
        T[] tmpNewPos = this.baseOram.lib.randBools(this.clients.get((int)(level - 1)).lengthOfPos);
        this.put(data, ithPos, tmpNewPos);
        currentOram.putBack(this.subIdentifier(iden, currentOram), poses[1], data);
        T[][] result = currentOram.env.newTArray(2, 0);
        result[0] = pos;
        result[1] = tmpNewPos;
        return result;
    }

    public T[] subIdentifier(T[] iden, OramParty<T> o) {
        return o.lib.padSignal(iden, o.lengthOfIden);
    }

    public T[] extract(T[] array, T[] ithPos, int length) {
        int numberOfEntry = array.length / length;
        T[] result = Arrays.copyOfRange(array, 0, length);
        int i = 1;
        while (i < numberOfEntry) {
            Object hit = this.baseOram.lib.eq(this.baseOram.lib.toSignals(i, ithPos.length), ithPos);
            result = this.baseOram.lib.mux(result, Arrays.copyOfRange(array, i * length, (i + 1) * length), hit);
            ++i;
        }
        return result;
    }

    public void put(T[] array, T[] ithPos, T[] content) {
        int numberOfEntry = array.length / content.length;
        int i = 0;
        while (i < numberOfEntry) {
            Object hit = this.baseOram.lib.eq(this.baseOram.lib.toSignals(i, ithPos.length), ithPos);
            T[] tmp = this.baseOram.lib.mux(Arrays.copyOfRange(array, i * content.length, (i + 1) * content.length), content, hit);
            System.arraycopy(tmp, 0, array, i * content.length, content.length);
            ++i;
        }
    }
}

