/*
 * Decompiled with CFR 0.152.
 */
import diff.SimplePartition;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parser.GitParserThread;
import util.Configuration;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        int i;
        Configuration conf = Configuration.init(logger, args);
        List<String> issue_paths = SimplePartition.splitFile(conf.getNumberOfCPUS(), conf.getIssuePath(), "./issues");
        if (issue_paths.isEmpty()) {
            return;
        }
        LinkedList<GitParserThread> parsers = new LinkedList<GitParserThread>();
        LinkedList<String> resPaths = new LinkedList<String>();
        for (i = 0; i < conf.getNumberOfCPUS(); ++i) {
            String resPath = String.format("%s/result%d", conf.getResultPath(), i);
            resPaths.add(resPath);
            parsers.add(new GitParserThread(i, issue_paths.get(i)));
            ((GitParserThread)parsers.get(i)).start();
        }
        for (i = 0; i < conf.getNumberOfCPUS(); ++i) {
            try {
                ((GitParserThread)parsers.get(i)).join();
                continue;
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
        SimplePartition.mergeFiles(resPaths, conf.getResultPath());
    }
}

