/*
 * Decompiled with CFR 0.152.
 */
package diff;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SimplePartition {
    private static String ANNOTATIONPATH = "annotations.json";
    private static String COMMITSPATH = "commits.json";
    private static String FIXINTRODUCERSPATH = "fix_and_introducers_pairs.json";
    private static String SUBFIXINTRODUCERSPATH = "fix_and_introducers_pairs_%d.json";

    private static List<String> splitJSON(int partitions, String path, String resPath) {
        ArrayList<String> paths = new ArrayList<String>();
        JSONParser parser = new JSONParser();
        try {
            JSONObject issues = (JSONObject)parser.parse(new FileReader(path));
            int size = issues.keySet().size();
            int div = size / partitions;
            int mod = size % partitions;
            ArrayList<Integer[]> chunks = new ArrayList<Integer[]>();
            for (int i = 0; i < partitions; ++i) {
                Integer[] chunk = new Integer[]{i * div + Math.min(i, mod), (i + 1) * div + Math.min(i + 1, mod)};
                if (i < partitions - 1) {
                    Integer[] integerArray = chunk;
                    Integer.valueOf(integerArray[1] - 1);
                }
                chunks.add(chunk);
            }
            ArrayList keys = new ArrayList(issues.keySet());
            for (int i = 0; i < partitions; ++i) {
                JSONObject chunkObject = new JSONObject();
                Integer[] chunk = (Integer[])chunks.get(i);
                int limit = i < partitions - 1 ? chunk[1] : chunk[1] - 1;
                for (int start = chunk[0].intValue(); start <= limit; ++start) {
                    String key = (String)keys.get(start);
                    chunkObject.put(key, issues.get(key));
                }
                String chunkPath = resPath + "/" + String.format(SUBFIXINTRODUCERSPATH, i);
                FileWriter writer = new FileWriter(chunkPath);
                writer.write(chunkObject.toJSONString());
                writer.flush();
                paths.add(chunkPath);
            }
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            return new LinkedList<String>();
        }
        return paths;
    }

    public static List<String> splitFile(int partitions, String path, String resPath) {
        LinkedList<String> paths = new LinkedList();
        File f = new File(path);
        if (!f.isFile()) {
            System.err.println("Path doesn't exists...");
            return new LinkedList<String>();
        }
        File resDir = new File(resPath);
        if (resDir.exists()) {
            System.err.println(String.format("%s already exists!", resPath));
            return new LinkedList<String>();
        }
        resDir.mkdirs();
        String extension = FilenameUtils.getExtension(path);
        if (!extension.equals("json")) {
            System.err.println("Unknown filetype...");
            return new LinkedList<String>();
        }
        paths = SimplePartition.splitJSON(partitions, path, resPath);
        return paths;
    }

    public static void mergeFiles(List<String> resPaths, String resPath) {
        LinkedList<JSONObject> commits = new LinkedList<JSONObject>();
        LinkedList<JSONObject> annotations = new LinkedList<JSONObject>();
        LinkedList<JSONArray> fix_and_introducers_pairs = new LinkedList<JSONArray>();
        JSONParser parser = new JSONParser();
        for (String string : resPaths) {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                try {
                    JSONObject jSONObject = (JSONObject)parser.parse(new FileReader(string + "/" + COMMITSPATH));
                    commits.add(jSONObject);
                    JSONObject annotation = (JSONObject)parser.parse(new FileReader(string + "/" + ANNOTATIONPATH));
                    annotations.add(annotation);
                    JSONArray pair = (JSONArray)parser.parse(new FileReader(string + "/" + FIXINTRODUCERSPATH));
                    fix_and_introducers_pairs.add(pair);
                }
                catch (IOException | ParseException exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            System.err.println(string + " doesn't exist! Omitting..");
        }
        JSONObject commitObject = new JSONObject();
        for (JSONObject jSONObject : commits) {
            for (Object c : jSONObject.keySet()) {
                commitObject.put(c, jSONObject.get(c));
            }
        }
        try {
            Throwable throwable = null;
            try (FileWriter fileWriter = new FileWriter(resPath + "/" + COMMITSPATH);){
                fileWriter.write(commitObject.toJSONString());
                fileWriter.flush();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        JSONObject jSONObject = new JSONObject();
        for (JSONObject jSONObject2 : annotations) {
            for (Object a : jSONObject2.keySet()) {
                jSONObject.put(a, jSONObject2.get(a));
            }
        }
        try {
            Throwable throwable = null;
            try (FileWriter fileWriter = new FileWriter(resPath + "/" + ANNOTATIONPATH);){
                fileWriter.write(jSONObject.toJSONString());
                fileWriter.flush();
            }
            catch (Throwable c) {
                Throwable throwable4 = c;
                throw c;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        JSONArray jSONArray = new JSONArray();
        for (JSONArray pair : fix_and_introducers_pairs) {
            jSONArray.addAll(pair);
        }
        try (FileWriter fileWriter = new FileWriter(resPath + "/" + FIXINTRODUCERSPATH);){
            fileWriter.write(jSONArray.toJSONString());
            fileWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

