/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import data.Issues;
import heuristics.BugIntroducerFinder;
import heuristics.DistanceIntroducerFinder;
import heuristics.SimpleBugIntroducerFinder;
import org.eclipse.jgit.lib.Repository;
import util.Configuration;

public class BugFinderFactory {
    public static final int SIMPLE = 1;
    public static final int DISTANCE = 2;

    public static BugIntroducerFinder getFinder(Repository repo, Issues issues) {
        Configuration conf = Configuration.getInstance();
        switch (conf.getBugFinder()) {
            case 1: {
                return new SimpleBugIntroducerFinder(issues, repo, conf.getDepth(), conf.getPartialFixPattern());
            }
            case 2: {
                return new DistanceIntroducerFinder(repo, conf.getDiffCustomContext());
            }
        }
        return null;
    }
}

