/*
 * Decompiled with CFR 0.152.
 */
package parser;

import data.Issues;
import graph.AnnotationMap;
import graph.FileAnnotationGraph;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import parser.Commit;
import parser.SimpleCommitSearcher;
import util.CommitUtil;
import util.JSONUtil;

public class GitParser {
    private CommitUtil util;
    private Repository repo;
    private Issues issues;
    private String resultPath;
    private String DEFAULT_RES_PATH = "./results";
    private Logger logger;
    private int depth;

    public GitParser(String path, String resultPath, int depth, int customContext) throws IOException, GitAPIException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setMustExist(true);
        builder.addCeilingDirectory(new File(path));
        builder.findGitDir(new File(path));
        this.repo = builder.build();
        this.resultPath = resultPath;
        if (this.resultPath != null) {
            File resDirectory = new File(resultPath);
            if (!resDirectory.exists()) {
                resDirectory.mkdirs();
            }
        } else {
            System.err.println("Resultpath not set! Using deafult directory instead.");
            this.resultPath = this.DEFAULT_RES_PATH;
        }
        this.util = new CommitUtil(this.repo, customContext);
        this.depth = depth;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public Issues getIssues() {
        return this.issues;
    }

    public void useLogger(Logger logger) {
        this.logger = logger;
    }

    private List<Integer> getLineMappings(BlameResult foundCommit, String filePath) throws IOException, GitAPIException {
        foundCommit.computeAll();
        RawText foundContent = foundCommit.getResultContents();
        LinkedList<Integer> lineMappings = new LinkedList<Integer>();
        for (int line = 0; line < foundContent.size(); ++line) {
            lineMappings.add(foundCommit.getSourceLine(line));
        }
        return lineMappings;
    }

    private int getSourceLine(BlameResult foundCommit, int index) throws IOException, GitAPIException {
        foundCommit.computeAll();
        try {
            return foundCommit.getSourceLine(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    private FileAnnotationGraph traceFileChanges(String filePath, Commit source, int step) throws IOException, GitAPIException {
        Commit subCommit;
        FileAnnotationGraph subGraph;
        Map.Entry rev2;
        if (step == 0) {
            return null;
        }
        BlameCommand command = new BlameCommand(this.repo);
        List delIndexes = null;
        if (!source.diffWithParent.containsKey(filePath)) {
            return null;
        }
        delIndexes = source.diffWithParent.get((Object)filePath).deletions.stream().map(s -> this.parseInt(s[0])).collect(Collectors.toList());
        FileAnnotationGraph graph = new FileAnnotationGraph();
        graph.filePath = filePath;
        graph.revisions = new LinkedList();
        graph.mappings = new HashMap<String, Map<Integer, Integer>>();
        graph.sub_graphs = new HashMap<String, FileAnnotationGraph>();
        graph.revisions.add(ObjectId.toString(source.commit.toObjectId()));
        int index = 0;
        RevCommit parent = source.commit.getParent(0);
        command.setStartCommit(parent);
        command.setFilePath(filePath);
        BlameResult found = command.call();
        if (found == null) {
            return graph;
        }
        HashMap foundRevisions = new HashMap();
        for (int i = 0; i < delIndexes.size(); ++i) {
            index = (Integer)delIndexes.get(i);
            if (index == -1) continue;
            try {
                RevCommit foundRev = found.getSourceCommit(i);
                if (!foundRevisions.containsKey(foundRev)) {
                    LinkedHashMap<Integer, Integer> blamedLines = new LinkedHashMap<Integer, Integer>();
                    blamedLines.put(index, this.getSourceLine(found, index));
                    foundRevisions.put(foundRev, blamedLines);
                    continue;
                }
                ((Map)foundRevisions.get(foundRev)).put(index, this.getSourceLine(found, index));
                continue;
            }
            catch (Exception foundRev) {
                // empty catch block
            }
        }
        for (Map.Entry rev2 : foundRevisions.entrySet()) {
            String revSha = ObjectId.toString(((RevCommit)rev2.getKey()).toObjectId());
            if (!graph.mappings.containsKey(revSha)) {
                graph.revisions.add(revSha);
                graph.mappings.put(revSha, (Map<Integer, Integer>)rev2.getValue());
                continue;
            }
            Map<Integer, Integer> linemapping = graph.mappings.get(revSha);
            for (Map.Entry entry : ((Map)rev2.getValue()).entrySet()) {
                if (linemapping.containsKey(entry.getKey())) continue;
                linemapping.put((Integer)entry.getKey(), (Integer)entry.getValue());
            }
        }
        Iterator iterator = foundRevisions.entrySet().iterator();
        while (iterator.hasNext() && (subGraph = this.traceFileChanges(filePath, subCommit = this.util.getCommitDiffingLines((RevCommit)(rev2 = iterator.next()).getKey(), new RevCommit[0]), step - 1)) != null) {
            graph.sub_graphs.put(subCommit.getHashString(), subGraph);
        }
        return graph;
    }

    private AnnotationMap<String, List<FileAnnotationGraph>> buildLineMappingGraph(List<Commit> commits) throws IOException, GitAPIException {
        AnnotationMap<String, List<FileAnnotationGraph>> fileGraph = new AnnotationMap<String, List<FileAnnotationGraph>>();
        for (Commit commit : commits) {
            LinkedList<FileAnnotationGraph> graphs = new LinkedList<FileAnnotationGraph>();
            for (Map.Entry<String, DiffEntry.ChangeType> file : commit.changeTypes.entrySet()) {
                FileAnnotationGraph tracedCommits = this.traceFileChanges(file.getKey(), commit, this.depth);
                graphs.add(tracedCommits);
            }
            fileGraph.put(commit.getHashString(), graphs);
        }
        return fileGraph;
    }

    private int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public AnnotationMap<String, List<FileAnnotationGraph>> annotateCommits(Set<RevCommit> commits) throws IOException, GitAPIException {
        this.logger.info("Parsing difflines for all found commits.");
        List<Commit> parsedCommits = this.util.getDiffingLines(commits);
        this.logger.info("Saving parsed commits to file");
        JSONUtil.saveFoundCommits(parsedCommits, this.resultPath);
        this.logger.info("Building line mapping graph.");
        AnnotationMap<String, List<FileAnnotationGraph>> mapping = this.buildLineMappingGraph(parsedCommits);
        this.logger.info("Saving results to file");
        mapping.saveToJSON(this.resultPath);
        return mapping;
    }

    public Set<RevCommit> readBugFixCommits(String path) throws IOException, GitAPIException {
        if (this.repo == null) {
            return Collections.emptySet();
        }
        this.issues = new Issues();
        JSONParser commitParser = new JSONParser();
        try {
            JSONObject object = (JSONObject)commitParser.parse(new FileReader(path));
            this.issues.revisions = new HashSet<RevCommit>();
            this.issues.dates = new HashMap<String, Map<String, String>>();
            for (Object issue : object.keySet()) {
                Map issueInfo = (Map)object.get(issue);
                String rev = (String)issueInfo.get("hash");
                RevCommit revCommit = this.repo.parseCommit(this.repo.resolve(rev));
                HashMap dates = new HashMap();
                dates.put("resolutiondate", issueInfo.get("resolutiondate"));
                dates.put("commitdate", issueInfo.get("commitdate"));
                dates.put("creationdate", issueInfo.get("creationdate"));
                this.issues.dates.put(rev, dates);
                this.issues.revisions.add(revCommit);
            }
        }
        catch (FileNotFoundException | ParseException e) {
            return Collections.emptySet();
        }
        this.logger.info(String.format("Found %d number of commits.", this.issues.revisions.size()));
        if (this.issues.revisions.size() == 0) {
            return Collections.emptySet();
        }
        return this.issues.revisions;
    }

    public Set<RevCommit> searchForBugFixes() throws IOException, GitAPIException {
        if (this.repo == null) {
            return Collections.emptySet();
        }
        SimpleCommitSearcher search = new SimpleCommitSearcher(this.repo);
        Set<RevCommit> foundCommits = search.filterOnBugPatterns();
        this.logger.info(String.format("Found %d number of commits", foundCommits.size()));
        if (foundCommits.size() == 0) {
            return Collections.emptySet();
        }
        return foundCommits;
    }
}

