/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import util.Configuration;

public class SimpleCommitSearcher {
    private Git git;
    private Repository repo;
    public List<Matcher> bugpatterns;

    public SimpleCommitSearcher(String repoPath) throws IOException, GitAPIException {
        Configuration conf = Configuration.getInstance();
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setMustExist(true);
        builder.addCeilingDirectory(new File(repoPath));
        builder.findGitDir(new File(repoPath));
        this.repo = builder.build();
        this.git = new Git(this.repo);
        this.bugpatterns = Arrays.asList(this.compile("JENKINS\\-[0-9]"));
    }

    public SimpleCommitSearcher(Repository repo) {
        this.repo = repo;
        this.git = new Git(repo);
        this.bugpatterns = Arrays.asList(this.compile("JENKINS\\-[0-9]"));
    }

    private Matcher compile(String pattern) {
        Pattern p = Pattern.compile(pattern, 32);
        return p.matcher("");
    }

    public int countCommits() throws IOException, GitAPIException {
        if (this.repo == null || this.git == null) {
            return -1;
        }
        Object logs = this.git.log().call();
        int count = 0;
        Iterator iterator = logs.iterator();
        while (iterator.hasNext()) {
            RevCommit recv = (RevCommit)iterator.next();
            ++count;
        }
        return count;
    }

    public Set<RevCommit> filterOnBugPatterns() throws IOException, GitAPIException {
        Object logs = this.git.log().call();
        HashSet<RevCommit> foundCommits = new HashSet<RevCommit>();
        boolean number = false;
        for (Matcher bug_matcher : this.bugpatterns) {
            Iterator iterator = logs.iterator();
            while (iterator.hasNext()) {
                RevCommit recv = (RevCommit)iterator.next();
                bug_matcher.reset(recv.getFullMessage());
                if (!bug_matcher.find()) continue;
                foundCommits.add(recv);
            }
        }
        return foundCommits;
    }
}

