/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RevisionCombinationGenerator {
    private int[] a;
    private int n;
    private int r;
    private BigInteger numLeft;
    private BigInteger total;
    private List<String> sa;
    private List<String> sb;

    public RevisionCombinationGenerator(List<String> sa, List<String> sb, int r) {
        this.n = sa.size() + sb.size();
        if (r > this.n) {
            throw new IllegalArgumentException();
        }
        if (this.n < 1) {
            throw new IllegalArgumentException();
        }
        this.r = r;
        this.sa = sa;
        this.sb = sb;
        this.a = new int[r];
        BigInteger nFact = RevisionCombinationGenerator.getFactorial(this.n);
        BigInteger rFact = RevisionCombinationGenerator.getFactorial(r);
        BigInteger nminusrFact = RevisionCombinationGenerator.getFactorial(this.n - r);
        this.total = nFact.divide(rFact.multiply(nminusrFact));
        this.reset();
    }

    public RevisionCombinationGenerator(int n, int r) {
        if (r > n) {
            throw new IllegalArgumentException();
        }
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.r = r;
        this.a = new int[r];
        BigInteger nFact = RevisionCombinationGenerator.getFactorial(n);
        BigInteger rFact = RevisionCombinationGenerator.getFactorial(r);
        BigInteger nminusrFact = RevisionCombinationGenerator.getFactorial(n - r);
        this.total = nFact.divide(rFact.multiply(nminusrFact));
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = i;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
        }
        return fact;
    }

    public int[] getNext() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
        int i = this.r - 1;
        while (this.a[i] == this.n - this.r + i) {
            --i;
        }
        this.a[i] = this.a[i] + 1;
        for (int j = i + 1; j < this.r; ++j) {
            this.a[j] = this.a[i] + j - i;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }

    public List<String[]> generateRevIssuePairs() {
        if (this.r != 2) {
            return Collections.emptyList();
        }
        LinkedList<String[]> combinations = new LinkedList<String[]>();
        HashSet<String> revs = new HashSet<String>(this.sa);
        HashSet<String> issues = new HashSet<String>(this.sb);
        List all_commits = Stream.concat(this.sa.stream(), this.sb.stream()).collect(Collectors.toList());
        boolean inRevs = false;
        while (this.hasMore()) {
            int[] indices = this.getNext();
            String c1 = (String)all_commits.get(indices[0]);
            String c2 = (String)all_commits.get(indices[1]);
            inRevs = revs.contains(c1);
            if (revs.contains(c1) && issues.contains(c2)) {
                combinations.add(new String[]{c1, c2});
                continue;
            }
            if (!revs.contains(c2) || !issues.contains(c1)) continue;
            combinations.add(new String[]{c2, c1});
        }
        return combinations;
    }
}

