/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import data.Issues;
import graph.AnnotationMap;
import graph.FileAnnotationGraph;
import heuristics.BugIntroducerFinder;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import util.RevisionCombinationGenerator;

public class SimpleBugIntroducerFinder
implements BugIntroducerFinder {
    private Issues issues;
    private Repository repo;
    private int depth;
    private Pattern partialFixPattern;

    public SimpleBugIntroducerFinder(Issues issues, Repository repo, int depth, String partialFixPattern) {
        this.issues = issues;
        this.repo = repo;
        this.depth = depth;
        this.partialFixPattern = Pattern.compile(partialFixPattern);
    }

    private boolean isWithinTimeframe(String fix, String commit) throws IOException, GitAPIException {
        Map<String, String> dates = this.issues.get(fix);
        RevCommit rCommit = this.repo.parseCommit(this.repo.resolve(commit));
        Date revisionDate = rCommit.getCommitterIdent().getWhen();
        String commitDateString = dates.get("creationdate");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        Date commitDate = null;
        try {
            commitDate = format.parse(commitDateString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return revisionDate.before(commitDate);
    }

    private boolean isPartialFix(String commit) throws IOException, GitAPIException {
        RevCommit rCommit = this.repo.parseCommit(this.repo.resolve(commit));
        String message = rCommit.getFullMessage();
        Matcher fixMatch = this.partialFixPattern.matcher(commit);
        return fixMatch.find();
    }

    private Collection<FileAnnotationGraph> getSubGraphs(Collection<FileAnnotationGraph> root, int depth) {
        LinkedList<FileAnnotationGraph> sub = new LinkedList<FileAnnotationGraph>();
        if (depth == 1) {
            return sub;
        }
        for (FileAnnotationGraph subGraph : root) {
            if (depth > 2) {
                sub.addAll(this.getSubGraphs(subGraph.sub_graphs.values(), depth - 1));
                sub.addAll(subGraph.sub_graphs.values());
            }
            sub.add(subGraph);
        }
        return sub;
    }

    @Override
    public List<String[]> findBugIntroducingCommits(AnnotationMap<String, List<FileAnnotationGraph>> graphs) throws IOException, GitAPIException {
        List<String[]> revisions;
        RevisionCombinationGenerator gen;
        List issues;
        List introducers;
        LinkedList<String[]> bugIntroducers = new LinkedList<String[]>();
        LinkedList potentialBugIntroducers = new LinkedList();
        HashMap bucketIntroducers = new HashMap();
        HashMap bucketIssues = new HashMap();
        for (Map.Entry entry : graphs.entrySet()) {
            LinkedList<FileAnnotationGraph> files = new LinkedList();
            String sCommitString = (String)entry.getKey();
            files = (List)entry.getValue();
            Collection<FileAnnotationGraph> subGraphs = this.getSubGraphs(files, this.depth);
            subGraphs.addAll(files);
            for (FileAnnotationGraph fileGraph : subGraphs) {
                Iterator revisions2 = fileGraph.revisions.iterator();
                revisions2.next();
                if (!revisions2.hasNext()) continue;
                while (revisions2.hasNext()) {
                    String rev = (String)revisions2.next();
                    String[] pair = new String[]{sCommitString, rev};
                    if (this.isWithinTimeframe(sCommitString, rev)) {
                        bugIntroducers.add(pair);
                        continue;
                    }
                    if (!bucketIntroducers.containsKey(fileGraph.filePath)) {
                        bucketIntroducers.put(fileGraph.filePath, new ArrayList());
                    }
                    ((List)bucketIntroducers.get(fileGraph.filePath)).add(rev);
                    if (!bucketIssues.containsKey(fileGraph.filePath)) {
                        bucketIssues.put(fileGraph.filePath, new ArrayList());
                    }
                    ((List)bucketIssues.get(fileGraph.filePath)).add(sCommitString);
                }
            }
        }
        LinkedList partial_fix_suspects = new LinkedList();
        HashMap partialIntroducers = new HashMap();
        HashMap partialIssues = new HashMap();
        for (Map.Entry entry : bucketIntroducers.entrySet()) {
            introducers = (List)entry.getValue();
            issues = (List)bucketIssues.get(entry.getKey());
            gen = new RevisionCombinationGenerator(introducers, issues, 2);
            revisions = gen.generateRevIssuePairs();
            for (String[] pair : revisions) {
                if (this.isWithinTimeframe(pair[1], pair[0])) {
                    bugIntroducers.add(pair);
                    continue;
                }
                if (!partialIntroducers.containsKey(entry.getKey())) {
                    partialIntroducers.put(entry.getKey(), new ArrayList());
                }
                ((List)partialIntroducers.get(entry.getKey())).add(pair[0]);
                if (!partialIssues.containsKey(entry.getKey())) {
                    partialIssues.put(entry.getKey(), new ArrayList());
                }
                ((List)partialIssues.get(entry.getKey())).add(pair[1]);
            }
        }
        for (Map.Entry suspects : partialIntroducers.entrySet()) {
            introducers = (List)suspects.getValue();
            issues = (List)partialIssues.get(suspects.getKey());
            gen = new RevisionCombinationGenerator(introducers, issues, 2);
            revisions = gen.generateRevIssuePairs();
            for (String[] pair : revisions) {
                if (!this.isPartialFix(pair[0])) continue;
                bugIntroducers.add(pair);
            }
        }
        return bugIntroducers;
    }
}

